package com.flybits.concierge.enums

/**
 * Defines what mode of display is to be used when displaying parts of the Concierge.
 *
 */
enum class ShowMode {

    /**
     * NEW_ACTIVITY will overtake the entire screen using an activity.
     */
    NEW_ACTIVITY,

    /**
     * OVERLAY will will overtake a sub-part of the screen using an activity, displaying the host activity
     * in the background.
     */
    OVERLAY,

    /**
     * EXTERNAL is to be used when the [ConciergeFragment] is nested within the client activity. This
     * only needs to be used for push notification display.
     */
    EXTERNAL
}
