/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.concierge.AuthenticationStatusListener;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.OnboardingListener;
import com.flybits.concierge.OptedStateChangeListener;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.NotificationsActivity;
import com.flybits.concierge.activities.SettingsActivity;
import com.flybits.concierge.fragments.FeedHolderFragment;
import com.flybits.concierge.fragments.OnboardingFragment;
import com.flybits.concierge.fragments.OptInFragment;
import com.flybits.concierge.fragments.SurveyFragment;
import com.flybits.concierge.fragments.TermsAndServicesFragment;
import com.flybits.concierge.models.Audio;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.models.Survey;
import com.flybits.concierge.repository.ModelConverter;
import com.flybits.concierge.repository.content.ContentGetter;
import com.flybits.concierge.services.AudioService;
import com.flybits.concierge.viewproviders.AudiosViewProvider;
import com.pierfrancescosoffritti.androidyoutubeplayer.utils.Utils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ConciergeFragment
extends Fragment
implements AuthenticationStatusListener,
OptedStateChangeListener,
FlybitsNavigator {
    public static final String INSTANCE_CURRENT_FRAGMENT = "instance_current_fragment";
    public static final int MESSAGE_TNC = 1;
    public static final int MESSAGE_ONBOARDING = 2;
    public static final String ARG_MENU_TYPE = "flybits_con_menu_type";
    private LinearLayout lytLoader;
    private TextView txtLoaderText;
    private LinearLayout errorViewContainer;
    private View mainViewContainer;
    private Context currentContext;
    private Fragment currentFragment;
    private IConciergeFragmentCallbacks currentCallback;
    private MediaBrowserCompat mediaBrowserCompat;
    private MediaControllerCompat mediaControllerCompat;
    private MediaControllerCompat.Callback pendingCallback;
    private Audio lastAudio = null;
    private boolean initializing = false;
    private boolean actionBarItemsVisible = true;
    private FlybitsConcierge flybitsConcierge;
    private MediaControllerCompat.Callback controllerCallback = new MediaControllerCompat.Callback(){

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
            FragmentActivity activity = ConciergeFragment.this.getActivity();
            if (activity != null) {
                Intent intent = new Intent("flybits_con_broadcast_audio_state");
                intent.putExtra("flybits_con_intent_extra_audio_state", (Parcelable)state);
                activity.sendBroadcast(intent);
            }
        }
    };
    private MediaBrowserCompat.ConnectionCallback mediaBrowserCompatConnectionCallback = new MediaBrowserCompat.ConnectionCallback(){

        public void onConnected() {
            super.onConnected();
            Context context = ConciergeFragment.this.getContext();
            if (context != null) {
                try {
                    Bundle extras;
                    ConciergeFragment.this.mediaControllerCompat = new MediaControllerCompat(context, ConciergeFragment.this.mediaBrowserCompat.getSessionToken());
                    ConciergeFragment.this.mediaControllerCompat.registerCallback(ConciergeFragment.this.controllerCallback);
                    if (ConciergeFragment.this.pendingCallback != null) {
                        ConciergeFragment.this.mediaControllerCompat.registerCallback(ConciergeFragment.this.pendingCallback);
                        ConciergeFragment.this.pendingCallback = null;
                    }
                    if ((extras = ConciergeFragment.this.mediaControllerCompat.getPlaybackState().getExtras()) != null && ConciergeFragment.this.lastAudio == null) {
                        ConciergeFragment.this.lastAudio = new Audio();
                        ((ConciergeFragment)ConciergeFragment.this).lastAudio.sourceURL = extras.getString("arg_currentAudioURL");
                    } else if (ConciergeFragment.this.lastAudio != null) {
                        ConciergeFragment.this.playFromMediaId(ConciergeFragment.this.lastAudio);
                    }
                }
                catch (RemoteException e) {
                    Logger.exception(null, (Exception)((Object)e));
                }
            }
        }
    };

    public void childMessage(int code, Object data) {
        switch (code) {
            case 1: {
                boolean result = (Boolean)data;
                if (result) {
                    this.initializeState(false);
                    break;
                }
                if (this.currentCallback == null) break;
                this.currentCallback.onTNCDecline();
                break;
            }
            case 2: {
                this.initializeState(false);
            }
        }
    }

    public static ConciergeFragment newInstance(MenuType menuType) {
        ConciergeFragment fragment = new ConciergeFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(ARG_MENU_TYPE, menuType.value);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.currentFragment = this.getChildFragmentManager().getFragment(savedInstanceState, INSTANCE_CURRENT_FRAGMENT);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.currentFragment != null) {
            this.getChildFragmentManager().putFragment(outState, INSTANCE_CURRENT_FRAGMENT, this.currentFragment);
        }
        outState.putBoolean("flybits_con_error_present", this.errorViewContainer.getVisibility() == 0);
    }

    public void onPause() {
        super.onPause();
        if (this.flybitsConcierge != null) {
            this.flybitsConcierge.unregisterAuthenticationStateListener(this);
            this.flybitsConcierge.unregisterOptedStateChangeListener(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.flybitsConcierge != null) {
            this.flybitsConcierge.registerAuthenticationStateListener(this);
            this.flybitsConcierge.registerOptedStateChangeListener(this);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_concierge, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            MenuType menuType = MenuType.fromInt(args.getInt(ARG_MENU_TYPE, MenuType.MENU_TYPE_APP_BAR.value));
            if (menuType == MenuType.MENU_TYPE_APP_BAR) {
                this.setHasOptionsMenu(true);
            }
        } else {
            this.setHasOptionsMenu(true);
        }
        this.lytLoader = (LinearLayout)view.findViewById(R.id.concierge_fragment_lytLoader);
        this.txtLoaderText = (TextView)view.findViewById(R.id.concierge_fragment_txtLoadingText);
        this.errorViewContainer = (LinearLayout)view.findViewById(R.id.concierge_fragment_error_holder);
        this.mainViewContainer = view.findViewById(this.contentLayout());
        view.findViewById(R.id.concierge_fragment_retry_button).setOnClickListener(view1 -> this.initializeState(false));
        ContentAnalytics contentAnalytics = new ContentAnalytics(this.getContext());
        FlybitsViewPopulator flybitsViewPopulator = new FlybitsViewPopulator(contentAnalytics);
        this.flybitsConcierge = FlybitsConcierge.with(this.currentContext);
        this.flybitsConcierge.registerFlybitsViewProvider(new AudiosViewProvider(this, flybitsViewPopulator));
        this.initializeState(false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.currentContext = context;
    }

    public void onDetach() {
        super.onDetach();
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.mediaBrowserCompat.disconnect();
        }
        this.disconnectFromAudioService();
    }

    private void initializeState(final boolean skipOnboarding) {
        if (this.initializing) {
            return;
        }
        this.initializing = true;
        this.errorViewContainer.setVisibility(8);
        this.mainViewContainer.setVisibility(4);
        if (this.flybitsConcierge.isAuthenticated()) {
            this.mainViewContainer.setVisibility(0);
            this.flybitsConcierge.isOptedInLocal(new ObjectResultCallback<Boolean>(){

                public void onSuccess(Boolean optedIn) {
                    ConciergeFragment.this.flybitsConcierge.unregisterAuthenticationStateListener(ConciergeFragment.this);
                    if (!optedIn.booleanValue()) {
                        ConciergeFragment.this.hideLoader();
                        ConciergeFragment.this.currentFragment = OptInFragment.Companion.newInstance();
                        FragmentManager manager = ConciergeFragment.this.getChildFragmentManager();
                        manager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment).addToBackStack(null).commit();
                        ConciergeFragment.this.setActionBarItemsVisibility(false);
                    } else if (!skipOnboarding && !InternalPreferences.isOnBoardingDone(ConciergeFragment.this.currentContext)) {
                        ConciergeFragment.this.hideLoader();
                        ConciergeFragment.this.findContentAndTakeover("ctn-flybits-concierge-onboarding");
                        InternalPreferences.saveOnBoardingDone(ConciergeFragment.this.currentContext, true);
                        ConciergeFragment.this.setActionBarItemsVisibility(false);
                    } else if (!InternalPreferences.isSurveyDone(ConciergeFragment.this.currentContext)) {
                        ConciergeFragment.this.hideLoader();
                        ConciergeFragment.this.findContentAndTakeover("SurveyQuestions");
                        InternalPreferences.saveSurveyDone(ConciergeFragment.this.currentContext, true);
                        ConciergeFragment.this.setActionBarItemsVisibility(false);
                    } else {
                        ConciergeFragment.this.hideLoader();
                        Bundle arguments = ConciergeFragment.this.getArguments();
                        boolean showMoreTab = false;
                        if (arguments != null) {
                            MenuType menuType = MenuType.fromInt(arguments.getInt(ConciergeFragment.ARG_MENU_TYPE, MenuType.MENU_TYPE_APP_BAR.value));
                            showMoreTab = menuType != MenuType.MENU_TYPE_APP_BAR;
                        }
                        ConciergeFragment.this.currentFragment = FeedHolderFragment.Companion.newInstance(showMoreTab);
                        FragmentManager manager = ConciergeFragment.this.getChildFragmentManager();
                        manager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment, ConciergeFragment.this.currentFragment.getClass().getSimpleName()).commit();
                        ConciergeFragment.this.setActionBarItemsVisibility(true);
                    }
                    ConciergeFragment.this.initializing = false;
                }

                public void onException(@NotNull FlybitsException e) {
                    ConciergeFragment.this.initializing = false;
                }
            });
        } else {
            boolean retrySuccess = this.flybitsConcierge.retryAuthentication();
            if (retrySuccess) {
                this.showLoader("");
            }
            this.errorViewContainer.setVisibility(0);
            this.setActionBarItemsVisibility(false);
            this.initializing = false;
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.menu, menu2);
        menu2.findItem(R.id.notifications).setVisible(this.actionBarItemsVisible);
        menu2.findItem(R.id.settings).setVisible(this.actionBarItemsVisible);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.settings) {
            Intent startSettingsIntent = new Intent(this.getContext(), SettingsActivity.class);
            this.startActivityForResult(startSettingsIntent, 1);
            return true;
        }
        if (id2 == R.id.notifications) {
            Intent startNotificationsIntent = new Intent(this.getContext(), NotificationsActivity.class);
            this.startActivity(startNotificationsIntent);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void setActionBarItemsVisibility(boolean visible) {
        this.actionBarItemsVisible = visible;
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.invalidateOptionsMenu();
        }
    }

    private void showTNCs() {
        this.currentFragment = TermsAndServicesFragment.newInstance(false);
        FragmentManager manager = this.getChildFragmentManager();
        manager.beginTransaction().replace(this.contentLayout(), this.currentFragment).commit();
    }

    private void findContentAndTakeover(String contentTemplateType) {
        ContentParameters params = new ContentParameters.Builder().setTemplateType(contentTemplateType).build();
        Content.get((Context)this.currentContext, (ContentParameters)params, (PagedResultCallback)new PagedResultCallback<Content>(){

            public void onSuccess(ArrayList<Content> items, Pagination pagination) {
                if (ConciergeFragment.this.getContext() == null) {
                    return;
                }
                if (items.size() != 0) {
                    ConciergeFragment.this.showContent(items.get(0));
                } else {
                    ConciergeFragment.this.initializeState(true);
                }
            }

            public void onException(FlybitsException exception) {
                ConciergeFragment.this.initializeState(true);
                InternalPreferences.saveSurveyDone(ConciergeFragment.this.getContext(), true);
            }

            public void onLoadedAllItems() {
            }
        });
    }

    private void showContent(Content contentToShow) {
        ModelConverter modelConverter = new ModelConverter(new ContentGetter(this.getContext()), this.flybitsConcierge);
        this.hideLoader();
        FragmentManager manager = this.getChildFragmentManager();
        switch (contentToShow.getType()) {
            case "ctn-flybits-concierge-onboarding": {
                Onboarding onboarding = (Onboarding)modelConverter.contentToBaseTemplate(contentToShow);
                if (onboarding == null) {
                    this.initializeState(true);
                    return;
                }
                OnboardingFragment onboardingFragment = OnboardingFragment.newInstance(onboarding);
                onboardingFragment.setOnboardingListener(new OnboardingListener(){

                    @Override
                    public void onSkip() {
                        ConciergeFragment.this.initializeState(false);
                    }

                    @Override
                    public void onFinished() {
                        ConciergeFragment.this.initializeState(false);
                    }
                });
                this.currentFragment = onboardingFragment;
                manager.beginTransaction().replace(this.contentLayout(), this.currentFragment, this.currentFragment.getClass().getSimpleName()).commit();
                break;
            }
            case "SurveyQuestions": {
                Survey survey = (Survey)modelConverter.contentToBaseTemplate(contentToShow);
                if (survey == null || survey.questions.getList().isEmpty()) {
                    new MaterialDialog.Builder((Context)this.getActivity()).title(R.string.flybits_con_error).content(R.string.flybits_con_dialog_survey_error).positiveText(17039370).show();
                    InternalPreferences.saveSurveyDone(this.getContext(), true);
                    this.initializeState(false);
                    return;
                }
                SurveyFragment surveyFragment = SurveyFragment.newInstance(survey);
                surveyFragment.setSurveyListener(() -> {
                    this.initializeState(false);
                    InternalPreferences.saveSurveyDone(this.currentContext, true);
                });
                this.currentFragment = surveyFragment;
                manager.beginTransaction().replace(this.contentLayout(), this.currentFragment, this.currentFragment.getClass().getSimpleName()).commit();
                break;
            }
            default: {
                this.initializeState(false);
            }
        }
    }

    private void connectToAudioService() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (this.mediaBrowserCompat == null) {
            this.mediaBrowserCompat = new MediaBrowserCompat(context.getApplicationContext(), new ComponentName(context.getApplicationContext(), AudioService.class), this.mediaBrowserCompatConnectionCallback, null);
        }
        this.mediaBrowserCompat.connect();
    }

    private void disconnectFromAudioService() {
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.mediaControllerCompat.unregisterCallback(this.controllerCallback);
            this.mediaBrowserCompat.disconnect();
        }
    }

    public void startAudio(Audio audio) {
        this.lastAudio = audio;
        boolean isOnline = Utils.isOnline((Context)this.currentContext);
        View view = this.getView();
        if (isOnline && (this.mediaBrowserCompat == null || !this.mediaBrowserCompat.isConnected())) {
            this.connectToAudioService();
        } else if (isOnline) {
            this.playFromMediaId(audio);
        } else if (view != null) {
            Snackbar.make((View)view, (int)R.string.flybits_con_audio_error_message, (int)0).show();
        }
    }

    public void registerMediaControllerCallback(MediaControllerCompat.Callback mediaControllerCallback) {
        if (mediaControllerCallback != null && this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.pendingCallback = null;
            this.mediaControllerCompat.registerCallback(mediaControllerCallback);
        } else {
            this.pendingCallback = mediaControllerCallback;
        }
    }

    public void resumeAudio() {
        View view = this.getView();
        Context context = this.getContext();
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected() && context != null && Utils.isOnline((Context)context)) {
            this.mediaControllerCompat.getTransportControls().play();
        } else if (view != null) {
            Snackbar.make((View)view, (int)R.string.flybits_con_audio_error_message, (int)0).show();
        }
    }

    public void pauseAudio() {
        if (this.mediaControllerCompat != null && this.mediaControllerCompat.getTransportControls() != null) {
            this.mediaControllerCompat.getTransportControls().pause();
        }
    }

    public void stopAudio() {
        this.lastAudio = null;
        if (this.mediaControllerCompat != null && this.mediaControllerCompat.getTransportControls() != null) {
            this.mediaControllerCompat.getTransportControls().stop();
        }
    }

    public int getAudioState() {
        if (this.mediaBrowserCompat == null || !this.mediaBrowserCompat.isConnected()) {
            if (Build.VERSION.SDK_INT >= 21) {
                return 0;
            }
            return 0;
        }
        return this.mediaControllerCompat.getPlaybackState().getState();
    }

    private void playFromMediaId(Audio audio) {
        Bundle args = new Bundle();
        if (audio.title != null) {
            args.putString("arg_title", audio.title.getValue());
        }
        if (audio.description != null) {
            args.putString("arg_desc", audio.description.getValue());
        }
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.mediaControllerCompat.getTransportControls().playFromMediaId(audio.sourceURL, args);
        }
    }

    public Audio getCurrentAudio() {
        return this.lastAudio;
    }

    @Override
    public void openFragment(@NotNull Fragment fragment, boolean addToBackStack) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity != null) {
            FragmentTransaction transaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
            if (addToBackStack) {
                transaction.addToBackStack(null);
            }
            transaction.replace(this.contentLayout(), fragment).commit();
        }
    }

    public void openActivity(Class activity, Bundle extras) {
        Intent intent = new Intent(this.currentContext, activity);
        intent.putExtras(extras);
        this.startActivity(intent);
    }

    private void showLoader(String title) {
        if (this.currentFragment != null) {
            this.getChildFragmentManager().beginTransaction().remove(this.currentFragment).commit();
        }
        this.txtLoaderText.setText((CharSequence)title);
        this.lytLoader.setVisibility(0);
    }

    private void hideLoader() {
        this.txtLoaderText.setText((CharSequence)"");
        this.lytLoader.setVisibility(8);
    }

    private int contentLayout() {
        return R.id.concierge_fragment_lytContent;
    }

    public void setCallback(IConciergeFragmentCallbacks callback) {
        this.currentCallback = callback;
    }

    @Override
    public void onAuthenticated() {
        this.initializeState(false);
    }

    @Override
    public void onAuthenticationStarted() {
    }

    @Override
    public void onAuthenticationError(FlybitsException e) {
        this.errorViewContainer.setVisibility(0);
        this.hideLoader();
    }

    @Override
    public void onOptedStateChange(boolean optedIn) {
        if (this.getActivity() != null) {
            this.initializeState(optedIn);
        }
    }

    @Override
    public boolean openUrl(@NotNull String url) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        if (intent.resolveActivity(activity.getPackageManager()) != null) {
            this.startActivity(intent);
            return true;
        }
        return false;
    }

    @Override
    public void openDialog(@NotNull String content, @NotNull String title) {
        new MaterialDialog.Builder((Context)this.getActivity()).title((CharSequence)title).content((CharSequence)content).positiveText(17039370).dismissListener(dialogInterface -> this.getActivity().finish()).show();
    }

    public static interface IConciergeFragmentCallbacks {
        public void onTNCDecline();
    }

    public static enum MenuType {
        MENU_TYPE_APP_BAR(0),
        MENU_TYPE_TAB(1);

        private int value;

        private MenuType(int value) {
            this.value = value;
        }

        public static MenuType fromInt(int type) {
            if (type == 0) {
                return MENU_TYPE_APP_BAR;
            }
            if (type == 1) {
                return MENU_TYPE_TAB;
            }
            throw new IllegalArgumentException("Type is invalid use TYPE_TAB or TYPE_APP_BAR");
        }

        public int getValue() {
            return this.value;
        }
    }
}

