package com.flybits.concierge.viewholders

import android.support.v7.widget.RecyclerView
import android.view.View
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.models.BaseTemplate

abstract class FlybitsViewHolder<T: BaseTemplate>(view: View): RecyclerView.ViewHolder(view) {

    /**
     * This method will be invoked whenever the RecyclerView's onBindViewHolder is invoked.
     *
     * @param data The deserialized content.
     * @param flybitsNavigator Used for navigating within the concierge.
     */
    abstract fun bindData(data: T, flybitsNavigator: FlybitsNavigator)

}