package com.flybits.concierge.fragments;


import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.OnboardingListener;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.models.OnboardingPage;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link OnboardingFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class OnboardingFragment extends Fragment implements ViewPager.OnPageChangeListener
{
    private static final String ARG_ONBOARDING = "flybits_con_on_boarding_arg";

    private Onboarding onboarding;
    private ViewPager pager;
    private Button skipButton;
    private OnboardingListener listener;
    private FlybitsViewPopulator flybitsViewPopulator;

    public OnboardingFragment()
    {
        // Required empty public constructor
    }

    public static OnboardingFragment newInstance(Onboarding onboarding)
    {
        OnboardingFragment fragment = new OnboardingFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_ONBOARDING, onboarding);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        if (getArguments() != null)
        {
            onboarding = getArguments().getParcelable(ARG_ONBOARDING);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.flybits_con_fragment_on_boarding, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)
    {
        super.onViewCreated(view, savedInstanceState);

        flybitsViewPopulator = new FlybitsViewPopulator(new ContentAnalytics(getContext().getApplicationContext()));
        pager = view.findViewById(R.id.flybits_con_fragment_on_boarding_viewPager);
        pager.addOnPageChangeListener(this);
        PagerAdapter adapter = new OnboardingAdapter();
        pager.setAdapter(adapter);

        TabLayout tabLayout = view.findViewById(R.id.flybits_con_fragment_on_boarding_tabLayout);
        tabLayout.setupWithViewPager(pager, true);

        skipButton = view.findViewById(R.id.flybits_con_fragment_on_boarding_btnFooter);
        skipButton.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                if (listener != null)
                {
                    int page = pager.getCurrentItem();

                    int lastPage = pager.getAdapter().getCount() - 1;

                    if (page == lastPage)
                    {
                        listener.onFinished();
                    }
                    else
                    {
                        listener.onSkip();
                    }
                }
                else
                {
                    getFragmentManager().popBackStack();
                }
            }
        });

        changeOnBoardingState();
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels)
    {
        // leave empty
    }

    @Override
    public void onPageSelected(int position)
    {
        changeOnBoardingState();
    }

    @Override
    public void onPageScrollStateChanged(int state)
    {
        // leave empty
    }

    public void setOnboardingListener(OnboardingListener listener)
    {
        this.listener = listener;
    }

    private void changeOnBoardingState()
    {
        int page = pager.getCurrentItem();

        int lastPage = pager.getAdapter().getCount() - 1;

        if (page == lastPage)
        {
            // change button text to FINISH
            skipButton.setText(R.string.flybits_con_fragment_on_boarding_finish);
        }
        else
        {
            // change button text to SKIP
            skipButton.setText(R.string.flybits_con_fragment_on_boarding_skip);
        }
    }

    public class OnboardingAdapter extends PagerAdapter
    {

        @Override
        public int getCount()
        {
            return onboarding.onboardingPages.getList().size();
        }

        @Override
        public boolean isViewFromObject(@NonNull View view, @NonNull Object object)
        {
            return view == object;
        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object)
        {
            // must be overridden
        }

        @NonNull
        @Override
        public Object instantiateItem(@NonNull ViewGroup container, int position)
        {
            View view = getLayoutInflater().inflate(R.layout.flybits_con_fragment_on_boarding_item, container, false);

            ImageView imageView    = view.findViewById(R.id.flybits_con_fragment_on_boarding_item_imgLogo);
            TextView titleTextView = view.findViewById(R.id.flybits_con_fragment_on_boarding_item_txtTitle);
            TextView bodyTextView  = view.findViewById(R.id.flybits_con_fragment_on_boarding_item_txtBody);

            OnboardingPage ob = onboarding.onboardingPages.getList().get(position);

            flybitsViewPopulator.populateOnboardingPageViews(ob, titleTextView, bodyTextView, imageView);

            container.addView(view);

            return view;
        }
    }
}
