package com.flybits.concierge.enums;

public enum QuestionType
{
    SINGLE("single"),
    STRING("string"),
    MULTIPLE("multiple"),
    NUMBER("number"),
    UNKNOWN("unknown");

    QuestionType(String text)
    {
        this.text = text;
    }

    private String text;

    public static QuestionType fromString(String text)
    {
        for (QuestionType type : QuestionType.values())
        {
            if (type.text.contentEquals(text))
            {
                return type;
            }
        }

        return UNKNOWN;
    }
}
