package com.flybits.concierge.activities

import android.content.Intent
import android.support.v4.app.Fragment
import com.flybits.concierge.fragments.ScheduleSegmentFragment
import com.flybits.concierge.models.ScheduleSegment

class ScheduleSegmentActivity: SingleFragmentActivity() {

    companion object {
        const val EXTRA_SCHEDULE_SEGMENT = "flybits_con_schedule_segment"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        val scheduleSegment = intent.getParcelableExtra<ScheduleSegment>(EXTRA_SCHEDULE_SEGMENT)
        title = scheduleSegment.title.value
        return ScheduleSegmentFragment.newInstance(scheduleSegment)
    }
}