/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.BaseTemplate;
import java.text.ParseException;
import java.util.Date;

public class Event
extends BaseTemplate {
    public LocalizedValue title;
    public String coverPhotoURL;
    public LocalizedValue venueDescription;
    public String url;
    public String address;
    public String phoneNumber;
    public String startDate;
    public String endDate;
    public LocalizedValue description;
    public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>(){

        public Event createFromParcel(Parcel in) {
            return new Event(in);
        }

        public Event[] newArray(int size) {
            return new Event[size];
        }
    };

    public Event() {
    }

    public Date getStartDate() {
        try {
            return Utils.toCalendar(this.startDate).getTime();
        }
        catch (ParseException e) {
            Logger.exception((String)Event.class.getSimpleName(), (Exception)e);
            return null;
        }
    }

    public Date getEndDate() {
        try {
            return Utils.toCalendar(this.endDate).getTime();
        }
        catch (ParseException e) {
            Logger.exception((String)Event.class.getSimpleName(), (Exception)e);
            return null;
        }
    }

    protected Event(Parcel in) {
        super(in);
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.coverPhotoURL = in.readString();
        this.venueDescription = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.url = in.readString();
        this.address = in.readString();
        this.phoneNumber = in.readString();
        this.startDate = in.readString();
        this.endDate = in.readString();
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeString(this.coverPhotoURL);
        dest.writeParcelable((Parcelable)this.venueDescription, flags);
        dest.writeString(this.url);
        dest.writeString(this.address);
        dest.writeString(this.phoneNumber);
        dest.writeString(this.startDate);
        dest.writeString(this.endDate);
        dest.writeParcelable((Parcelable)this.description, flags);
    }
}

