package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.ConciergeConstants.LINK_CONTENT_TYPE
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.R
import com.flybits.concierge.models.Links
import com.flybits.concierge.viewholders.LinksViewHolder

class LinksViewProvider: FlybitsViewProvider<Links> {

    override fun onCreateViewHolder(parent: ViewGroup): LinksViewHolder {
        return LinksViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.flybits_con_item_template_links, parent, false))
    }

    override fun getClassType() = Links::class.java

    override fun getContentType() = LINK_CONTENT_TYPE

    override fun onPushOpened(model: Links, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openUrl(model.links.list[0].url)
    }
}