package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import android.arch.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.repository.CategoryDatabase
import com.flybits.concierge.repository.CategorySettingsRepository

class FeedHolderViewModelFactory(context: Context): ViewModelProvider.Factory {

    private val flybitsConcierge = FlybitsConcierge.with(context.applicationContext)
    private val categorySettingsRepository: CategorySettingsRepository

    init {
        val categoryDao = CategoryDatabase.getInstance(context)!!.categoryDao()
        categorySettingsRepository = CategorySettingsRepository(categoryDao, context)
    }

    override fun <T : ViewModel?> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(FeedHolderViewModel::class.java)){
            FeedHolderViewModel(flybitsConcierge, categorySettingsRepository) as T
        } else {
            throw IllegalArgumentException("ViewModel Not Found")
        }
    }
}