package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import android.arch.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.android.kernel.db.KernelDatabase
import com.flybits.android.kernel.db.dao.ContentDao
import com.flybits.concierge.ContentRepository
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.FlybitsViewProviderGetter
import com.flybits.concierge.ResourceProvider
import com.flybits.internal.db.CommonsDatabase
import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors

class CategoryViewModelFactory(context: Context, private val flybitsViewProviderGetter: FlybitsViewProviderGetter
                               , private val category: String): ViewModelProvider.Factory {

    //Maybe one day we can use Dagger to inject these
    private val flybitsConcierge = FlybitsConcierge.with(context.applicationContext)
    private val contentRepository: ContentRepository = ContentRepository(context.applicationContext
            , KernelDatabase.getDatabase(context.applicationContext).contentDao()
            , flybitsViewProviderGetter)
    private val contentAnalytics: ContentAnalytics = ContentAnalytics(context.applicationContext)
    private val executorService: ExecutorService = Executors.newSingleThreadExecutor()
    private val resourceProvider: ResourceProvider = ResourceProvider(context.applicationContext)

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(CategoryViewModel::class.java)){
            CategoryViewModel(category, flybitsConcierge, contentRepository
                    , contentAnalytics, executorService, resourceProvider) as T
        } else {
            throw IllegalArgumentException("ViewModel Not Found")
        }
    }

}