package com.flybits.concierge.viewholders;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.TextView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.OnboardingFragment;
import com.flybits.concierge.models.Onboarding;

public class OnboardingViewHolder extends FlybitsViewHolder<Onboarding>
{

    private View thisView;
    private TextView titleTextView;

    public OnboardingViewHolder(View itemView)
    {
        super(itemView);
        this.thisView = itemView;
        titleTextView = itemView.findViewById(R.id.flybits_con_item_on_boarding_txtTitle);
    }

    @Override
    public void bindData(@NonNull final Onboarding data, final FlybitsNavigator flybitsNavigator)
    {
        data.populateViews(titleTextView);

        thisView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                OnboardingFragment fragment = OnboardingFragment.newInstance(data);
                flybitsNavigator.openFragment(fragment);
            }
        });
    }
}
