package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.concierge.enums.ScheduleDay;

import java.util.List;

public class ScheduleDaily extends BaseTemplate
{
    public ScheduleDaily()
    {
    }

    public String dayOfTheWeek;
    public List<ScheduleSegment> segmentDetails;

    protected ScheduleDaily(Parcel in)
    {
        super(in);
        dayOfTheWeek = in.readString();
        segmentDetails = in.createTypedArrayList(ScheduleSegment.CREATOR);
    }

    public static final Creator<ScheduleDaily> CREATOR = new Creator<ScheduleDaily>()
    {
        @Override
        public ScheduleDaily createFromParcel(Parcel in)
        {
            return new ScheduleDaily(in);
        }

        @Override
        public ScheduleDaily[] newArray(int size)
        {
            return new ScheduleDaily[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeString(dayOfTheWeek);
        dest.writeTypedList(segmentDetails);
    }

    public ScheduleDay getScheduleDay()
    {
        return ScheduleDay.fromString(dayOfTheWeek);
    }
}
