package com.flybits.concierge.models;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;

public class Article extends BaseTemplate
{
    public LocalizedValue title;
    public LocalizedValue description;
    public String imageURL;
    public String sourceName;
    public String url;

    public Article()
    {
    }

    protected Article(Parcel in)
    {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        imageURL = in.readString();
        sourceName = in.readString();
        url = in.readString();
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(imageURL);
        dest.writeString(sourceName);
        dest.writeString(url);
    }

    public static final Creator<Article> CREATOR = new Creator<Article>()
    {
        @Override
        public Article createFromParcel(Parcel in)
        {
            return new Article(in);
        }

        @Override
        public Article[] newArray(int size)
        {
            return new Article[size];
        }
    };

    public void populateViews(ImageView headerView, TextView titleView, TextView sourceView, TextView descriptionView, View openLinkView)
    {
        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);

        Glide.with(headerView.getContext())
                .load(imageURL)
                .apply(options)
                .into(headerView);

        titleView.setText(title.getValue());
        sourceView.setVisibility(!TextUtils.isEmpty(sourceName) ? View.VISIBLE : View.INVISIBLE);
        sourceView.setText(sourceName);
        descriptionView.setText(description.getValue());

        openLinkView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                String url = Article.this.url;
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setData(Uri.parse(url));
                v.getContext().startActivity(intent);
            }
        });
    }
}
