/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewmodels;

import android.app.Activity;
import android.app.Application;
import android.arch.core.util.Function;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.LiveData;
import android.arch.paging.LivePagedListBuilder;
import android.arch.paging.PagedList;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.results.ContentResult;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.FlybitsManager;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.APIUsageExceededException;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.NotConnectedException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeConfiguration;
import com.flybits.concierge.ContentHelper;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.R;
import com.flybits.concierge.models.BaseTemplate;
import com.twitter.sdk.android.core.DefaultLogger;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterAuthConfig;
import com.twitter.sdk.android.core.TwitterConfig;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FeedViewModel
extends AndroidViewModel
implements PagedResultCallback<Content> {
    public static final int PAGE_SIZE = 15;
    public static final int PRE_FETCH_DISTANCE = 5;
    public static final int INITIAL_LOAD_SIZE = 45;
    private ContentResult contentResult;
    private RefreshResultListener refreshResultListener;
    private FeedErrorDisplayer feedErrorDisplayer;
    private Handler uiHandler;
    private ContentDao contentDao;
    private BroadcastReceiver receiver;
    private ExecutorService executorService;
    private boolean loadedAll = false;

    public FeedViewModel(@NonNull Application application) {
        super(application);
        ConciergeConfiguration twitterConfig = FlybitsConcierge.with((Context)application).getConfiguration();
        String twitterKey = twitterConfig.getApiKey("key_twitter_consumer");
        String twitterSecret = twitterConfig.getApiKey("key_twitter_secret");
        if (!TextUtils.isEmpty((CharSequence)twitterKey) && !TextUtils.isEmpty((CharSequence)twitterSecret)) {
            TwitterConfig config = new TwitterConfig.Builder((Context)application).logger((com.twitter.sdk.android.core.Logger)new DefaultLogger(3)).twitterAuthConfig(new TwitterAuthConfig(twitterKey, twitterSecret)).debug(true).build();
            Twitter.initialize((TwitterConfig)config);
        }
        this.uiHandler = new Handler(application.getMainLooper());
        this.executorService = Executors.newSingleThreadExecutor();
        this.contentDao = KernelDatabase.getDatabase((Context)application).contentDao();
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                FeedViewModel.this.refresh(null);
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("flybits_con_broadcast_content_add");
        intentFilter.addAction("flybits_con_broadcast_content_update");
        intentFilter.addAction("flybits_con_broadcast_content_remove");
        intentFilter.addAction("flybits_con_broadcast_rule_update");
        intentFilter.addAction("flybits_con_broadcast_rule_state");
        application.registerReceiver(this.receiver, intentFilter);
        this.refresh(null);
    }

    protected void onCleared() {
        if (this.receiver != null) {
            this.getApplication().unregisterReceiver(this.receiver);
        }
        super.onCleared();
    }

    public void refresh(RefreshResultListener refreshResultListener) {
        this.loadedAll = false;
        this.contentResult = null;
        this.requestContent();
        this.refreshResultListener = refreshResultListener;
    }

    private void requestContent() {
        if (this.contentResult == null) {
            ContentParameters params = ((ContentParameters.Builder)new ContentParameters.Builder().setPaging(15L, 0L)).setCaching(this.getApplication().getString(R.string.flybits_con_cache_key), 45).build();
            this.contentResult = Content.get((Context)this.getApplication().getApplicationContext(), (ContentParameters)params, (PagedResultCallback)this);
        }
    }

    public void setFeedErrorDisplayer(FeedErrorDisplayer feedErrorDisplayer) {
        this.feedErrorDisplayer = feedErrorDisplayer;
    }

    public LiveData<PagedList<BaseTemplate>> getFeedContent() {
        this.loadedAll = false;
        PagedList.Config config = new PagedList.Config.Builder().setInitialLoadSizeHint(45).setPageSize(15).setEnablePlaceholders(false).setPrefetchDistance(5).build();
        return new LivePagedListBuilder(this.contentDao.getDataSourceContent().map((Function)new Function<Content, BaseTemplate>(){

            public BaseTemplate apply(Content input) {
                return ContentHelper.contentToBaseTemplate(input, (Context)FeedViewModel.this.getApplication());
            }
        }), config).setBoundaryCallback((PagedList.BoundaryCallback)new PagedList.BoundaryCallback<BaseTemplate>(){

            public void onZeroItemsLoaded() {
                Logger.d((String)"onZeroItemsLoaded()");
                FeedViewModel.this.requestContent();
            }

            public void onItemAtEndLoaded(@NonNull BaseTemplate itemAtEnd) {
                Logger.d((String)"onItemAtEndLoaded() ");
                if (!FeedViewModel.this.loadedAll) {
                    FeedViewModel.this.contentResult = (ContentResult)FeedViewModel.this.contentResult.getMore((PagedResultCallback)FeedViewModel.this);
                }
            }
        }).build();
    }

    public void onSuccess(ArrayList<Content> items) {
        Logger.d((String)("onSuccess() items count: " + items.size()));
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (FeedViewModel.this.refreshResultListener != null) {
                    FeedViewModel.this.refreshResultListener.onFinished();
                    FeedViewModel.this.refreshResultListener = null;
                }
            }
        });
        final ArrayList<String> ids = new ArrayList<String>();
        for (Content content : items) {
            switch (content.getType()) {
                case "SurveyQuestions": 
                case "ctn-flybits-concierge-onboarding": {
                    ids.add(content.getId());
                }
            }
        }
        if (!ids.isEmpty()) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    FeedViewModel.this.contentDao.deleteByIds(ids);
                }
            });
        }
    }

    public void onException(final FlybitsException exception) {
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                Logger.exception((String)this.getClass().getSimpleName(), (Exception)((Object)exception));
                if (exception instanceof NotConnectedException || exception instanceof APIUsageExceededException) {
                    FlybitsConcierge.with((Context)FeedViewModel.this.getApplication()).unauthenticateWithoutLogout(exception);
                }
                if (FeedViewModel.this.refreshResultListener != null) {
                    FeedViewModel.this.refreshResultListener.onFinished();
                    FeedViewModel.this.refreshResultListener = null;
                }
                if (FeedViewModel.this.feedErrorDisplayer != null) {
                    FeedViewModel.this.feedErrorDisplayer.onError(FeedViewModel.this.getApplication().getString(R.string.flybits_con_generic_error));
                }
            }
        });
    }

    public void onLoadedAllItems() {
        this.loadedAll = true;
    }

    public void connectAndDownLoad(final Activity activity, final String metaDataId, final ObjectResultCallback<Content> callback) {
        FlybitsManager.isConnected((Context)activity, (boolean)true, (ConnectionResultCallback)new ConnectionResultCallback(){

            public void onConnected() {
                Content.getById((Context)activity, (String)metaDataId, (ObjectResultCallback)callback);
            }

            public void notConnected() {
            }

            public void onException(final FlybitsException exception) {
                FeedViewModel.this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onException(exception);
                        }
                    }
                });
            }
        });
    }

    public static interface RefreshResultListener {
        public void onFinished();
    }

    public static interface FeedErrorDisplayer {
        public void onError(String var1);
    }
}

