/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewholders;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.fragments.ScheduleFeedFragment;
import com.flybits.concierge.fragments.ScheduleSegmentFragment;
import com.flybits.concierge.models.Schedule;
import com.flybits.concierge.models.ScheduleSegment;
import com.flybits.concierge.viewholders.BaseViewHolder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ScheduleViewHolder
extends BaseViewHolder<Schedule> {
    private static final int DAYS_SHOWN = 7;
    private final ConciergeFragment conciergeFragment;
    private final LinearLayout container;
    private TextView showMoreTextView;
    private TextView viewAllTextView;
    private boolean isExpanded;
    private final List<View> segmentViews;
    private boolean hasMultipleDays;
    private View lastVisibleView;

    public ScheduleViewHolder(ConciergeFragment conciergeFragment, View view) {
        super(conciergeFragment, view);
        this.conciergeFragment = conciergeFragment;
        this.segmentViews = new ArrayList<View>();
        this.showMoreTextView = (TextView)view.findViewById(R.id.flybits_con_item_template_schedule_txtShowMore);
        this.viewAllTextView = (TextView)view.findViewById(R.id.flybits_con_item_template_schedule_txtViewAll);
        this.container = (LinearLayout)view.findViewById(R.id.flybits_con_item_template_schedule_lytContainer);
    }

    @Override
    public void bindData(final Schedule data) {
        this.container.removeAllViews();
        this.segmentViews.clear();
        this.isExpanded = false;
        this.viewAllTextView.setVisibility(8);
        this.lastVisibleView = null;
        this.buildCells(data);
        this.showMoreTextView.setVisibility(this.segmentViews.size() < 3 ? 8 : 0);
        for (View view : this.segmentViews) {
            View rule;
            if (this.container.getChildCount() == this.segmentViews.size() - 1) {
                rule = view.findViewById(R.id.flybits_con_item_template_schedule_segment_viewRuleBottom);
                rule.setVisibility(4);
            }
            if ((rule = view.findViewById(R.id.flybits_con_item_template_schedule_title_viewTopRule)) != null && this.container.getChildCount() > 0) {
                rule.setVisibility(0);
            }
            this.container.addView(view);
            view.setVisibility(this.container.getChildCount() < 3 ? 0 : 8);
            if (view.getVisibility() != 0) continue;
            this.lastVisibleView = view;
        }
        this.showMoreTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ScheduleViewHolder.this.isExpanded = !ScheduleViewHolder.this.isExpanded;
                ScheduleViewHolder.this.showMoreTextView.setText(ScheduleViewHolder.this.isExpanded ? R.string.flybits_con_schedule_show_less : R.string.flybits_con_schedule_show_more);
                ScheduleViewHolder.this.viewAllTextView.setVisibility(ScheduleViewHolder.this.isExpanded && ScheduleViewHolder.this.hasMultipleDays ? 0 : 8);
                ScheduleViewHolder.this.handleLastVisibleRule();
                for (int i = 2; i < ScheduleViewHolder.this.segmentViews.size(); ++i) {
                    ((View)ScheduleViewHolder.this.segmentViews.get(i)).setVisibility(ScheduleViewHolder.this.isExpanded ? 0 : 8);
                }
            }
        });
        this.viewAllTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ScheduleFeedFragment fragment = ScheduleFeedFragment.newInstance(data);
                ScheduleViewHolder.this.conciergeFragment.openFragment(fragment);
            }
        });
        this.handleLastVisibleRule();
    }

    private void buildCells(Schedule data) {
        Map<String, LinkedList<ScheduleSegment>> weekdays = data.generateSegmentList();
        this.hasMultipleDays = weekdays.keySet().size() > 1;
        Calendar now = Calendar.getInstance();
        for (int i = 0; i < 7; ++i) {
            String weekDay = Utils.getWeekDayString(now.getTime());
            LinkedList<ScheduleSegment> todaySegments = weekdays.get(weekDay);
            if (todaySegments != null) {
                View dateTitleView = LayoutInflater.from((Context)this.container.getContext()).inflate(R.layout.flybits_con_item_template_schedule_title, (ViewGroup)this.container, false);
                TextView textView = (TextView)dateTitleView.findViewById(R.id.flybits_con_item_template_schedule_title_txtTitle);
                textView.setText((CharSequence)Utils.getDateString(now.getTime()));
                this.segmentViews.add(dateTitleView);
                for (final ScheduleSegment segment : todaySegments) {
                    View segmentView = LayoutInflater.from((Context)this.container.getContext()).inflate(R.layout.flybits_con_item_template_schedule_segment, (ViewGroup)this.container, false);
                    TextView timeRangeView = (TextView)segmentView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTimeRange);
                    TextView titleView = (TextView)segmentView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTitle);
                    TextView descriptionView = (TextView)segmentView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtDescription);
                    ImageView bulletOutView = (ImageView)segmentView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletOut);
                    ImageView bulletInView = (ImageView)segmentView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletIn);
                    View clickableArea = segmentView.findViewById(R.id.flybits_con_item_template_schedule_segment_lytContainer);
                    clickableArea.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            ScheduleSegmentFragment fragment = ScheduleSegmentFragment.newInstance(segment);
                            ScheduleViewHolder.this.conciergeFragment.openFragment(fragment);
                        }
                    });
                    segment.populateViews(timeRangeView, titleView, descriptionView, bulletOutView, bulletInView, clickableArea);
                    this.segmentViews.add(segmentView);
                }
                break;
            }
            if (now.get(6) == now.getActualMaximum(6)) {
                now.set(6, 1);
                now.set(1, now.get(1) + 1);
                continue;
            }
            now.set(6, now.get(6) + 1);
        }
    }

    private void handleLastVisibleRule() {
        View bottomRule;
        if (this.lastVisibleView != null && (bottomRule = this.lastVisibleView.findViewById(R.id.flybits_con_item_template_schedule_segment_viewRuleBottom)) != null) {
            bottomRule.setVisibility(this.isExpanded ? 0 : 4);
        }
    }
}

