/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.concierge.enums.FeedView;
import com.flybits.concierge.enums.ScheduleDay;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.ScheduleDaily;
import com.flybits.concierge.models.ScheduleSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Schedule
extends BaseTemplate
implements Parcelable {
    private Map<String, LinkedList<ScheduleSegment>> weekdays;
    public PagedArray<ScheduleDaily> schedule;
    public static final Parcelable.Creator<Schedule> CREATOR = new Parcelable.Creator<Schedule>(){

        public Schedule createFromParcel(Parcel in) {
            return new Schedule(in);
        }

        public Schedule[] newArray(int size) {
            return new Schedule[size];
        }
    };

    public Schedule() {
    }

    protected Schedule(Parcel in) {
        this.schedule = (PagedArray)in.readParcelable(PagedArray.class.getClassLoader());
    }

    @Override
    public FeedView getType() {
        return FeedView.SCHEDULE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.schedule, flags);
    }

    public Map<String, LinkedList<ScheduleSegment>> generateSegmentList() {
        if (this.weekdays != null) {
            return this.weekdays;
        }
        this.weekdays = new HashMap<String, LinkedList<ScheduleSegment>>();
        this.weekdays.put(ScheduleDay.SUNDAY.getText(), new LinkedList());
        this.weekdays.put(ScheduleDay.MONDAY.getText(), new LinkedList());
        this.weekdays.put(ScheduleDay.TUESDAY.getText(), new LinkedList());
        this.weekdays.put(ScheduleDay.WEDNESDAY.getText(), new LinkedList());
        this.weekdays.put(ScheduleDay.THURSDAY.getText(), new LinkedList());
        this.weekdays.put(ScheduleDay.FRIDAY.getText(), new LinkedList());
        this.weekdays.put(ScheduleDay.SATURDAY.getText(), new LinkedList());
        for (ScheduleDaily daily : this.schedule.getList()) {
            block7: for (ScheduleSegment scheduleSegment : daily.segmentDetails) {
                switch (daily.getScheduleDay()) {
                    case UNKNOWN: {
                        continue block7;
                    }
                    case WEEKDAY: {
                        this.weekdays.get(ScheduleDay.MONDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.TUESDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.WEDNESDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.TUESDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.FRIDAY.getText()).add(scheduleSegment);
                        continue block7;
                    }
                    case WEEKEND: {
                        this.weekdays.get(ScheduleDay.SATURDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.SUNDAY.getText()).add(scheduleSegment);
                        continue block7;
                    }
                    case EVERYDAY: {
                        this.weekdays.get(ScheduleDay.MONDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.TUESDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.WEDNESDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.TUESDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.FRIDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.SATURDAY.getText()).add(scheduleSegment);
                        this.weekdays.get(ScheduleDay.SUNDAY.getText()).add(scheduleSegment);
                        continue block7;
                    }
                }
                this.weekdays.get(daily.dayOfTheWeek).add(scheduleSegment);
            }
        }
        Set<String> keys = this.weekdays.keySet();
        ArrayList<String> markedForDeletion = new ArrayList<String>();
        for (String key : keys) {
            LinkedList<ScheduleSegment> segments = this.weekdays.get(key);
            if (segments.size() != 0) {
                Collections.sort(segments, new Comparator<ScheduleSegment>(){

                    @Override
                    public int compare(ScheduleSegment left, ScheduleSegment right) {
                        return left.getStartDayTime().compareTo(right.getStartDayTime());
                    }
                });
                continue;
            }
            markedForDeletion.add(key);
        }
        for (String day : markedForDeletion) {
            this.weekdays.remove(day);
        }
        return this.weekdays;
    }
}

