/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.enums.FeedView;
import com.flybits.concierge.models.BaseTemplate;

public class Link
extends BaseTemplate
implements Parcelable {
    public LocalizedValue title;
    public LocalizedValue description;
    public String url;
    public static final Parcelable.Creator<Link> CREATOR = new Parcelable.Creator<Link>(){

        public Link createFromParcel(Parcel in) {
            return new Link(in);
        }

        public Link[] newArray(int size) {
            return new Link[size];
        }
    };

    public Link() {
    }

    protected Link(Parcel in) {
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.url = in.readString();
    }

    @Override
    public FeedView getType() {
        return FeedView.LINK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeParcelable((Parcelable)this.description, flags);
        dest.writeString(this.url);
    }

    public void populateViews(TextView txtHeading, TextView txtBody, View linkView) {
        txtHeading.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)this.title.getValue()) ? this.title.getValue() : ""));
        txtBody.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)this.description.getValue()) ? this.description.getValue() : ""));
        txtBody.setVisibility(TextUtils.isEmpty((CharSequence)this.description.getValue()) ? 8 : 0);
        linkView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String url = Link.this.url;
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                v.getContext().startActivity(intent);
            }
        });
    }
}

