/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.app.Activity;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.arch.paging.PagedList;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.ContentHelper;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.ConciergeActivity;
import com.flybits.concierge.activities.ConciergePopupActivity;
import com.flybits.concierge.adapters.FeedAdapter;
import com.flybits.concierge.fragments.BasePagerFragment;
import com.flybits.concierge.fragments.EventDetailsFragment;
import com.flybits.concierge.fragments.ImageViewerPagerFragment;
import com.flybits.concierge.fragments.OnboardingFragment;
import com.flybits.concierge.fragments.ScheduleFeedFragment;
import com.flybits.concierge.fragments.SurveyFragment;
import com.flybits.concierge.fragments.VideoPlaylistFragment;
import com.flybits.concierge.models.Article;
import com.flybits.concierge.models.Articles;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Event;
import com.flybits.concierge.models.Events;
import com.flybits.concierge.models.Images;
import com.flybits.concierge.models.Link;
import com.flybits.concierge.models.Links;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.models.Schedule;
import com.flybits.concierge.models.Survey;
import com.flybits.concierge.models.Text;
import com.flybits.concierge.models.Videos;
import com.flybits.concierge.viewmodels.FeedViewModel;
import com.flybits.concierge.viewmodels.TwitterViewModel;

public class FeedFragment
extends BasePagerFragment
implements FeedViewModel.FeedErrorDisplayer {
    private RecyclerView recyclerView;
    private FeedViewModel feedViewModel;
    private FeedAdapter feedAdapter;
    private View noDataView;
    private BroadcastReceiver refreshReceiver;
    private SwipeRefreshLayout swipeRefreshLayout;

    public static FeedFragment newInstance() {
        FeedFragment fragment = new FeedFragment();
        return fragment;
    }

    @Override
    public int titleRes() {
        return R.string.flybits_con_fragment_title_feed;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_feed, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        view.findViewById(R.id.flybits_con_fragment_feed_settings_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment parentFragment = FeedFragment.this.getParentFragment();
                if (parentFragment != null && parentFragment instanceof ConciergeFragment) {
                    ((ConciergeFragment)parentFragment).startSettingsActivity();
                }
            }
        });
        this.recyclerView = (RecyclerView)view.findViewById(R.id.flybits_con_fragment_feed_lytRecycler);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.feedAdapter = new FeedAdapter((ConciergeFragment)this.getParentFragment());
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.feedAdapter);
        this.recyclerView.setHasFixedSize(false);
        this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.flybits_con_swipe_ref_layout);
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                Logger.d((String)(FeedFragment.class.getSimpleName() + ": onRefresh()"));
                FeedFragment.this.swipeRefreshLayout.setEnabled(false);
                FeedFragment.this.feedViewModel.refresh(new FeedViewModel.RefreshResultListener(){

                    @Override
                    public void onFinished() {
                        FeedFragment.this.swipeRefreshLayout.setEnabled(true);
                        FeedFragment.this.swipeRefreshLayout.setRefreshing(false);
                    }
                });
                if (FeedFragment.this.getContext() != null) {
                    TwitterViewModel twitterViewModel = (TwitterViewModel)ViewModelProviders.of((FragmentActivity)((FragmentActivity)FeedFragment.this.getContext())).get(TwitterViewModel.class);
                    twitterViewModel.clearTweetLists();
                }
            }
        });
        this.noDataView = view.findViewById(R.id.flybits_con_fragment_feed_lytNoData);
        this.feedViewModel = (FeedViewModel)ViewModelProviders.of((Fragment)this).get(FeedViewModel.class);
        this.swipeRefreshLayout.setRefreshing(true);
        this.feedViewModel.getFeedContent().observe((LifecycleOwner)this, (Observer)new Observer<PagedList<BaseTemplate>>(){

            public void onChanged(@Nullable PagedList<BaseTemplate> baseTemplates) {
                Logger.d((String)("Got data! data: " + baseTemplates));
                FeedFragment.this.feedAdapter.submitList(baseTemplates);
                boolean baseTemplatesEmpty = baseTemplates.isEmpty();
                FeedFragment.this.recyclerView.setVisibility(baseTemplatesEmpty ? 8 : 0);
                FeedFragment.this.noDataView.setVisibility(baseTemplatesEmpty ? 0 : 8);
                FeedFragment.this.swipeRefreshLayout.setRefreshing(false);
            }
        });
        this.feedViewModel.setFeedErrorDisplayer(this);
        this.refreshReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (FeedFragment.this.feedAdapter != null) {
                    try {
                        FeedFragment.this.feedAdapter.notifyDataSetChanged();
                    }
                    catch (Exception e) {
                        Logger.exception((String)"FeedFragment.RefreshReceiver.onReceiver()", (Exception)e);
                    }
                }
            }
        };
        this.handlePushInvoke();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.registerReceiver(this.refreshReceiver, new IntentFilter("flybits_con_broadcast_audio_state"));
            }
        }
        catch (Exception e) {
            Logger.exception((String)"FeedFragment.onCreate()", (Exception)e);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        try {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.unregisterReceiver(this.refreshReceiver);
            }
        }
        catch (Exception e) {
            Logger.exception((String)"FeedFragment.onDestroy()", (Exception)e);
        }
    }

    private void handlePushInvoke() {
        FragmentActivity activity = this.getActivity();
        if (activity == null || activity.getIntent() == null) {
            return;
        }
        String metaDataId = activity.getIntent().getStringExtra("flybits_con_push_content_id");
        String url = activity.getIntent().getStringExtra("flybits_con_push_content_url");
        if (metaDataId != null) {
            this.feedViewModel.connectAndDownLoad((Activity)activity, metaDataId, new ObjectResultCallback<Content>(){

                public void onSuccess(Content item) {
                    FeedFragment.this.presentContent(item);
                }

                public void onException(FlybitsException e) {
                    FragmentActivity currentActivity = FeedFragment.this.getActivity();
                    if (currentActivity != null) {
                        new MaterialDialog.Builder((Context)currentActivity).title(R.string.flybits_con_error).content(R.string.flybits_con_could_not_load).positiveText(17039370).dismissListener(new DialogInterface.OnDismissListener((Activity)currentActivity){
                            final /* synthetic */ Activity val$currentActivity;
                            {
                                this.val$currentActivity = activity;
                            }

                            public void onDismiss(DialogInterface dialog) {
                                this.val$currentActivity.finish();
                            }
                        }).show();
                    }
                    Logger.exception((String)FeedFragment.class.getSimpleName(), (Exception)((Object)e));
                }
            });
        } else if (url != null) {
            this.openUrl(url);
        }
    }

    private void openUrl(String url) {
        FragmentActivity activity = this.getActivity();
        if (activity == null || url == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        this.startActivity(intent);
        activity.finish();
    }

    private void presentContent(Content content) {
        BaseTemplate contentObject = ContentHelper.contentToBaseTemplate(content, this.getContext());
        FragmentActivity activity = this.getActivity();
        if (activity == null || contentObject == null) {
            return;
        }
        Fragment fragment = null;
        switch (content.getType()) {
            case "ctn-flybits-concierge-article": {
                Articles articles = (Articles)contentObject;
                if (articles.articles.getList().size() <= 0) break;
                this.openUrl(((Article)articles.articles.getList().get((int)0)).url);
                break;
            }
            case "ctn-flybits-concierge-event": {
                Events events = (Events)contentObject;
                fragment = events.events.getList().size() > 1 ? EventDetailsFragment.newInstance((Event)events.events.getList().get(0)) : null;
                break;
            }
            case "ctn-flybits-concierge-image": {
                Images images = (Images)contentObject;
                fragment = ImageViewerPagerFragment.newInstance(images.images, 0);
                break;
            }
            case "ctn-flybits-concierge-link": {
                Links links = (Links)contentObject;
                if (links.links.getList().size() <= 0) break;
                this.openUrl(((Link)links.links.getList().get((int)0)).url);
                break;
            }
            case "ctn-flybits-concierge-onboarding": {
                Onboarding onboarding = (Onboarding)contentObject;
                fragment = OnboardingFragment.newInstance(onboarding);
                break;
            }
            case "ctn-flybits-concierge-schedule": {
                Schedule schedule = (Schedule)contentObject;
                fragment = ScheduleFeedFragment.newInstance(schedule);
                break;
            }
            case "SurveyQuestions": {
                Survey survey = (Survey)contentObject;
                fragment = SurveyFragment.newInstance(survey);
                break;
            }
            case "ctn-flybits-concierge-text": {
                Text text = (Text)contentObject;
                new MaterialDialog.Builder((Context)activity).title((CharSequence)text.header.getValue()).content((CharSequence)text.description.getValue()).positiveText(17039370).dismissListener(new DialogInterface.OnDismissListener((Activity)activity){
                    final /* synthetic */ Activity val$activity;
                    {
                        this.val$activity = activity;
                    }

                    public void onDismiss(DialogInterface dialog) {
                        this.val$activity.finish();
                    }
                }).show();
                break;
            }
            case "ctn-flybits-concierge-video": {
                Videos videos = (Videos)contentObject;
                fragment = VideoPlaylistFragment.newInstance(videos.videos.getList());
                break;
            }
            default: {
                new MaterialDialog.Builder((Context)activity).title(R.string.flybits_con_error).content(R.string.flybits_con_not_supported).positiveText(17039370).dismissListener(new DialogInterface.OnDismissListener((Activity)activity){
                    final /* synthetic */ Activity val$activity;
                    {
                        this.val$activity = activity;
                    }

                    public void onDismiss(DialogInterface dialog) {
                        this.val$activity.finish();
                    }
                }).show();
                return;
            }
        }
        ConciergeFragment conciergeFragment = (ConciergeFragment)this.getParentFragment();
        if (fragment != null && conciergeFragment != null) {
            conciergeFragment.openFragment(fragment);
        }
    }

    @Override
    public void onError(String err) {
        Logger.d((String)("FeedFragment: onAuthenticationError() err: " + err));
        FragmentActivity activity = this.getActivity();
        View v = this.getView();
        if (activity != null && (activity instanceof ConciergeActivity || activity instanceof ConciergePopupActivity) && v != null) {
            Snackbar.make((View)v, (CharSequence)err, (int)0).show();
        }
    }
}

