/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.Context;
import android.util.Log;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.models.Answer;
import com.flybits.concierge.models.Articles;
import com.flybits.concierge.models.Audios;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Events;
import com.flybits.concierge.models.Images;
import com.flybits.concierge.models.Links;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.models.Result;
import com.flybits.concierge.models.Schedule;
import com.flybits.concierge.models.Survey;
import com.flybits.concierge.models.Text;
import com.flybits.concierge.models.Twitters;
import com.flybits.concierge.models.Videos;
import com.flybits.concierge.viewmodels.FeedViewModel;
import java.util.Locale;

public class ContentHelper {
    public static BaseTemplate contentToBaseTemplate(Content content, Context context) {
        Class typeClass = null;
        switch (content.getType()) {
            case "SurveyAnswers": {
                typeClass = Answer.class;
                break;
            }
            case "ctn-flybits-concierge-article": {
                typeClass = Articles.class;
                break;
            }
            case "ctn-flybits-concierge-event": {
                typeClass = Events.class;
                break;
            }
            case "ctn-flybits-concierge-image": {
                typeClass = Images.class;
                break;
            }
            case "ctn-flybits-concierge-link": {
                typeClass = Links.class;
                break;
            }
            case "ctn-flybits-concierge-onboarding": {
                typeClass = Onboarding.class;
                break;
            }
            case "SurveyResults": {
                typeClass = Result.class;
                break;
            }
            case "ctn-flybits-concierge-schedule": {
                typeClass = Schedule.class;
                break;
            }
            case "SurveyQuestions": {
                typeClass = Survey.class;
                break;
            }
            case "ctn-flybits-concierge-text": {
                typeClass = Text.class;
                break;
            }
            case "ctn-flybits-concierge-twitter": {
                typeClass = Twitters.class;
                break;
            }
            case "ctn-flybits-concierge-audio": {
                typeClass = Audios.class;
                break;
            }
            case "ctn-flybits-concierge-video": {
                typeClass = Videos.class;
                break;
            }
            default: {
                Log.d((String)ContentHelper.class.getSimpleName(), (String)String.format(Locale.getDefault(), "Developer: Invalid Template Found: %s", content.getType()));
            }
        }
        try {
            BaseTemplate contentObject = (BaseTemplate)content.getData(context, typeClass);
            if (contentObject != null) {
                contentObject.setContent(content);
                return contentObject;
            }
        }
        catch (FlybitsException e) {
            Logger.d((String)String.format(Locale.getDefault(), "Developer: Invalid Template Found: %s", content.getType()));
            Logger.exception((String)FeedViewModel.class.getSimpleName(), (Exception)((Object)e));
        }
        return null;
    }
}

