/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewholders;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Image;
import com.flybits.concierge.models.Images;
import com.flybits.concierge.viewholders.BaseViewHolder;

public class ImageViewHolder
extends BaseViewHolder<Images>
implements View.OnClickListener {
    private View thisView;
    private ImageView singleView;
    private View doubleView;
    private View multipleView;
    private ImageView[] doubleImages;
    private ImageView[] multipleImages;
    private ConciergeFragment conciergeFragment;
    private Images currentBoundImage;

    public ImageViewHolder(ConciergeFragment conciergeFragment, View itemView) {
        super(conciergeFragment, itemView);
        this.conciergeFragment = conciergeFragment;
        this.thisView = itemView;
        this.singleView = (ImageView)itemView.findViewById(R.id.flybits_con_item_image_imgSingle);
        this.doubleImages = new ImageView[]{(ImageView)itemView.findViewById(R.id.flybits_con_item_image_imgDoubleLeft), (ImageView)itemView.findViewById(R.id.flybits_con_item_image_imgDoubleRight)};
        this.multipleImages = new ImageView[]{(ImageView)itemView.findViewById(R.id.flybits_con_item_image_imgBig), (ImageView)itemView.findViewById(R.id.flybits_con_item_image_imgTR), (ImageView)itemView.findViewById(R.id.flybits_con_item_image_imgBR)};
        this.doubleView = itemView.findViewById(R.id.flybits_con_item_image_lytDouble);
        this.multipleView = itemView.findViewById(R.id.flybits_con_item_image_lytTriple);
    }

    @Override
    public void bindData(Images images) {
        ImageView[] imageViews;
        super.bindData(images);
        this.currentBoundImage = images;
        this.singleView.setVisibility(8);
        this.doubleView.setVisibility(8);
        this.multipleView.setVisibility(8);
        RequestOptions options = new RequestOptions().centerCrop().format(DecodeFormat.PREFER_RGB_565);
        if (images.images.getList().size() == 1) {
            Image image = (Image)images.images.getList().get(0);
            this.singleView.setVisibility(0);
            Glide.with((Context)this.thisView.getContext()).load(image.url).apply(options).into(this.singleView);
            this.singleView.setOnClickListener((View.OnClickListener)this);
            return;
        }
        switch (images.images.getList().size()) {
            default: {
                imageViews = this.multipleImages;
                this.multipleView.setVisibility(0);
                break;
            }
            case 2: {
                imageViews = this.doubleImages;
                this.doubleView.setVisibility(0);
            }
        }
        for (int i = 0; i < imageViews.length; ++i) {
            ImageView imgView = imageViews[i];
            Glide.with((Context)this.thisView.getContext()).load(((Image)images.images.getList().get((int)i)).url).apply(options).into(imgView);
            imgView.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View view) {
        if (view.equals(this.singleView)) {
            this.conciergeFragment.openImageViewer(this.currentBoundImage.images, 0);
        } else {
            for (int i = 0; i < this.multipleImages.length; ++i) {
                if ((i >= this.doubleImages.length || !view.equals(this.doubleImages[i])) && !view.equals(this.multipleImages[i])) continue;
                this.conciergeFragment.openImageViewer(this.currentBoundImage.images, i);
                break;
            }
        }
    }
}

