/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.R;

public class TermsAndServicesFragment
extends Fragment {
    private static final String FLAG_VIEWING_ONLY = "viewing_only";
    private WebView webBody;
    private CheckBox chkAccept;
    private Button btnDecline;
    private Button btnAccept;
    private Context currentContext;
    private ConciergeFragment parentFragment;
    private View loadView;
    private View errorView;
    private View errorRetryButton;
    private View buttonHolder;
    private String tncURL = "";
    private boolean viewingOnly = false;
    private boolean errorPresent = false;
    private boolean loading = false;

    public static TermsAndServicesFragment newInstance(boolean viewingOnly) {
        TermsAndServicesFragment termsAndServicesFragment = new TermsAndServicesFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean(FLAG_VIEWING_ONLY, viewingOnly);
        termsAndServicesFragment.setArguments(bundle);
        return termsAndServicesFragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.currentContext = context;
        this.parentFragment = (ConciergeFragment)this.getParentFragment();
    }

    public void setArguments(@Nullable Bundle args) {
        if (args != null) {
            this.viewingOnly = args.getBoolean(FLAG_VIEWING_ONLY);
        }
        super.setArguments(args);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.flybits_con_fragment_tnc, container, false);
        return v;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.webBody = (WebView)view.findViewById(R.id.flybits_con_fragment_tnc_webBody);
        this.chkAccept = (CheckBox)view.findViewById(R.id.flybits_con_fragment_tnc_chkAccept);
        this.btnDecline = (Button)view.findViewById(R.id.flybits_con_fragment_tnc_btnDecline);
        this.btnAccept = (Button)view.findViewById(R.id.flybits_con_fragment_tnc_btnAccept);
        this.loadView = view.findViewById(R.id.flybits_con_tnc_fragment_prgLoading);
        this.errorView = view.findViewById(R.id.flybits_con_fragment_tnc_error_holder);
        this.errorRetryButton = view.findViewById(R.id.offline_fragment_retry_button);
        this.buttonHolder = view.findViewById(R.id.flybits_con_tnc_button_holder);
        this.errorRetryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TermsAndServicesFragment.this.loadWebView(TermsAndServicesFragment.this.tncURL);
            }
        });
        if (this.viewingOnly) {
            this.btnDecline.setVisibility(8);
            this.btnAccept.setVisibility(8);
            this.chkAccept.setVisibility(8);
        }
        if (savedInstanceState == null) {
            this.tncURL = FlybitsConcierge.with((Context)this.getActivity()).getConfiguration().getTNCUrl();
            if (this.tncURL != null) {
                this.loadWebView(this.tncURL);
            }
        } else {
            this.loading = savedInstanceState.getBoolean("flybits_con_loading");
            this.tncURL = savedInstanceState.getString("flybits_con_url");
            if (this.loading) {
                this.loading = false;
                this.loadWebView(this.tncURL);
            } else {
                this.webBody.restoreState(savedInstanceState);
                this.chkAccept.setChecked(savedInstanceState.getBoolean("checkbox"));
                this.errorPresent = savedInstanceState.getBoolean("flybits_con_error_present");
                if (this.errorPresent) {
                    this.errorView.setVisibility(0);
                    this.webBody.setVisibility(8);
                    this.buttonHolder.setVisibility(8);
                } else {
                    this.errorView.setVisibility(8);
                    this.webBody.setVisibility(0);
                    this.buttonHolder.setVisibility(0);
                }
            }
        }
        this.btnAccept.setEnabled(this.chkAccept.isChecked());
        this.btnDecline.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TermsAndServicesFragment.this.parentFragment.childMessage(1, false);
            }
        });
        this.btnAccept.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InternalPreferences.saveTNCAccepted(TermsAndServicesFragment.this.currentContext, true);
                TermsAndServicesFragment.this.parentFragment.childMessage(1, true);
            }
        });
        this.chkAccept.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                TermsAndServicesFragment.this.btnAccept.setEnabled(b);
            }
        });
    }

    private void loadWebView(String tncURL) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.errorPresent = false;
        this.webBody.loadUrl(tncURL);
        this.loadView.setVisibility(0);
        this.webBody.setVisibility(8);
        this.chkAccept.setClickable(false);
        this.webBody.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                TermsAndServicesFragment.this.loading = false;
                TermsAndServicesFragment.this.loadView.setVisibility(8);
                if (TermsAndServicesFragment.this.errorPresent) {
                    TermsAndServicesFragment.this.buttonHolder.setVisibility(8);
                    TermsAndServicesFragment.this.webBody.setVisibility(8);
                    TermsAndServicesFragment.this.errorView.setVisibility(0);
                } else {
                    TermsAndServicesFragment.this.errorView.setVisibility(0);
                    TermsAndServicesFragment.this.buttonHolder.setVisibility(0);
                    TermsAndServicesFragment.this.webBody.setVisibility(0);
                    TermsAndServicesFragment.this.chkAccept.setClickable(true);
                }
                super.onPageFinished(view, url);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                TermsAndServicesFragment.this.errorPresent = true;
                super.onReceivedError(view, request, error);
            }
        });
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.webBody.saveState(outState);
        outState.putBoolean("flybits_con_loading", this.loading);
        outState.putBoolean("flybits_con_error_present", this.errorPresent);
        outState.putBoolean("checkbox", this.chkAccept.isChecked());
        outState.putString("flybits_con_url", this.tncURL);
    }
}

