/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.adapters;

import android.arch.paging.PagedListAdapter;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.util.DiffUtil;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.enums.FeedView;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.viewholders.ArticlesViewHolder;
import com.flybits.concierge.viewholders.AudiosViewHolder;
import com.flybits.concierge.viewholders.BaseViewHolder;
import com.flybits.concierge.viewholders.EventsViewHolder;
import com.flybits.concierge.viewholders.ImageViewHolder;
import com.flybits.concierge.viewholders.LinksViewHolder;
import com.flybits.concierge.viewholders.OnboardingViewHolder;
import com.flybits.concierge.viewholders.ScheduleViewHolder;
import com.flybits.concierge.viewholders.SurveyViewHolder;
import com.flybits.concierge.viewholders.TextViewHolder;
import com.flybits.concierge.viewholders.TwitterViewHolder;
import com.flybits.concierge.viewholders.UnknownViewHolder;
import com.flybits.concierge.viewholders.VideosViewHolder;

public class FeedAdapter
extends PagedListAdapter<BaseTemplate, BaseViewHolder> {
    private ConciergeFragment conFrag;
    private static final DiffUtil.ItemCallback<BaseTemplate> ITEM_CALLBACK = new DiffUtil.ItemCallback<BaseTemplate>(){

        public boolean areItemsTheSame(BaseTemplate oldItem, BaseTemplate newItem) {
            return oldItem.getContent().getId().equals(newItem.getContent().getId());
        }

        public boolean areContentsTheSame(BaseTemplate oldItem, BaseTemplate newItem) {
            return oldItem.getContent().equals((Object)newItem.getContent());
        }
    };

    public FeedAdapter(ConciergeFragment conFrag) {
        super(ITEM_CALLBACK);
        this.conFrag = conFrag;
    }

    @NonNull
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        switch (FeedView.values()[viewType]) {
            case ARTICLES: {
                return new ArticlesViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_articles, parent, false));
            }
            case SCHEDULE: {
                return new ScheduleViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_schedule, parent, false));
            }
            case TEXT: {
                return new TextViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_text, parent, false));
            }
            case ONBOARDING: {
                return new OnboardingViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_on_boarding, parent, false));
            }
            case VIDEOS: {
                return new VideosViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_videos, parent, false));
            }
            case IMAGES: {
                return new ImageViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_image, parent, false));
            }
            case SURVEY: {
                return new SurveyViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_survey, parent, false));
            }
            case LINKS: {
                return new LinksViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_links, parent, false));
            }
            case EVENTS: {
                return new EventsViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_events, parent, false));
            }
            case AUDIOS: {
                return new AudiosViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_audios, parent, false));
            }
            case TWITTERS: {
                return new TwitterViewHolder(this.conFrag, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_twitter, parent, false));
            }
        }
        TextView textView = (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(17367043, parent, false);
        textView.setTextColor(ContextCompat.getColor((Context)parent.getContext(), (int)R.color.flybits_con_primary));
        return new UnknownViewHolder(this.conFrag, (View)textView);
    }

    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position) {
        holder.bindData((BaseTemplate)this.getItem(position));
        if (holder instanceof ArticlesViewHolder) {
            ArticlesViewHolder articlesHolder = (ArticlesViewHolder)holder;
            articlesHolder.setPagerId(position);
        }
    }

    public int getItemCount() {
        return this.getCurrentList().size();
    }

    public int getItemViewType(int position) {
        BaseTemplate dataClass = (BaseTemplate)this.getItem(position);
        return dataClass == null ? 0 : dataClass.getType().ordinal();
    }

    public long getItemId(int position) {
        return ((BaseTemplate)this.getItem(position)).getContent().getCreatedAt();
    }
}

