/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.UserDAO;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/flybits/commons/library/SharedElementsInMemory;", "Lcom/flybits/commons/library/SharedElements;", "sharedPreferences", "Landroid/content/SharedPreferences;", "userDAO", "Lcom/flybits/internal/db/UserDAO;", "keepSP", "", "(Landroid/content/SharedPreferences;Lcom/flybits/internal/db/UserDAO;Z)V", "performMigration", "", "context", "Landroid/content/Context;", "args", "", "", "setStringVariable", "", "key", "value", "commons_release"})
public final class SharedElementsInMemory
extends SharedElements {
    private boolean keepSP;

    @Override
    protected int performMigration(@NotNull Context context, @NotNull Map<String, String> args) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        SharedPreferences backupPreferences = context.getSharedPreferences("FLYBITS_PREF_BACKUP", 0);
        int migratedCount = 0;
        if (backupPreferences.contains("com.flybits.jwt.token")) {
            String string = backupPreferences.getString("com.flybits.jwt.token", "");
            if (string == null) {
                string = "";
            }
            this.setJWTToken(string);
            ++migratedCount;
        }
        if (backupPreferences.contains("com.flybits.project.id")) {
            String string = backupPreferences.getString("com.flybits.project.id", "");
            if (string == null) {
                string = "";
            }
            this.setProjectID(string);
            ++migratedCount;
        }
        if (backupPreferences.contains("com.flybits.idp.connected")) {
            String string = backupPreferences.getString("com.flybits.idp.connected", "");
            if (string == null) {
                string = "";
            }
            this.setConnectedIDP(string);
            ++migratedCount;
        }
        if (backupPreferences.contains("com.flybits.language.codes")) {
            ArrayList<String> arrayList = Utilities.convertLocalizationStringToList(backupPreferences.getString("com.flybits.language.codes", ""));
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"Utilities.convertLocaliz\u2026PREF_LANGUAGE_CODES, \"\"))");
            this.setLocalization(arrayList);
            ++migratedCount;
        }
        if (migratedCount > 0) {
            backupPreferences.edit().clear().apply();
        }
        if (this.keepSP) {
            return migratedCount;
        }
        if (this.getSharedPreferences().contains("com.flybits.jwt.token")) {
            this.getSharedPreferences().edit().putString("com.flybits.jwt.token", "").apply();
            ++migratedCount;
        }
        if (this.getSharedPreferences().contains("com.flybits.idp.connected")) {
            this.getSharedPreferences().edit().putString("com.flybits.idp.connected", "").apply();
            ++migratedCount;
        }
        return migratedCount;
    }

    @Override
    public void setStringVariable(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = key;
        if (StringsKt.contains$default((CharSequence)"com.flybits.jwt.token", (CharSequence)string, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)string, (Object)"com.flybits.idp.connected")) {
            return;
        }
        this.getSharedPreferences().edit().putString(key, value).apply();
    }

    public SharedElementsInMemory(@NotNull SharedPreferences sharedPreferences, @NotNull UserDAO userDAO, boolean keepSP) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkParameterIsNotNull((Object)userDAO, (String)"userDAO");
        super(sharedPreferences, userDAO, null, 4, null);
        this.keepSP = keepSP;
    }

    public /* synthetic */ SharedElementsInMemory(SharedPreferences sharedPreferences, UserDAO userDAO, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(sharedPreferences, userDAO, bl);
    }
}

