/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.idps;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.idps.IDP;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthIDP
extends IDP {
    private static final String AUTHENTICATE_ENDPOINT = "/oauth";
    private String accessToken;
    private String clientID;
    private String provider;
    public static final Parcelable.Creator<OAuthIDP> CREATOR = new Parcelable.Creator<OAuthIDP>(){

        public OAuthIDP createFromParcel(Parcel in) {
            return new OAuthIDP(in);
        }

        public OAuthIDP[] newArray(int size) {
            return new OAuthIDP[size];
        }
    };

    private OAuthIDP(Parcel in) {
        super(in);
        this.accessToken = in.readString();
        this.clientID = in.readString();
        this.provider = in.readString();
    }

    public OAuthIDP(@NonNull String provider, @NonNull String accessToken) {
        super(provider);
        this.provider = provider;
        this.accessToken = accessToken;
    }

    public OAuthIDP(@NonNull SupportedIDP idp, @NonNull String accessToken) {
        this(idp.getKey(), accessToken);
    }

    public OAuthIDP(@NonNull String provider, @NonNull String accessToken, String clientID) {
        this(provider, accessToken);
        this.clientID = clientID;
    }

    public OAuthIDP(@NonNull SupportedIDP idp, @NonNull String accessToken, String clientID) {
        this(idp.getKey(), accessToken, clientID);
    }

    @Override
    public String getAuthenticationEndPoint() {
        return AUTHENTICATE_ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        JSONObject bodyObject = new JSONObject();
        try {
            bodyObject.put("provider", (Object)this.provider);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            bodyObject.put("accessToken", (Object)this.accessToken);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (this.clientID != null) {
            try {
                bodyObject.put("clientID", (Object)this.clientID);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return bodyObject;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(this.accessToken);
        out.writeString(this.clientID);
        out.writeString(this.provider);
    }

    public static enum SupportedIDP {
        OKTA("okta"),
        FACEBOOK("facebook"),
        GOOGLE("gplus");

        private final String key;

        private SupportedIDP(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static SupportedIDP fromKey(String key) {
            for (SupportedIDP type : SupportedIDP.values()) {
                if (!type.getKey().equalsIgnoreCase(key)) continue;
                return type;
            }
            return null;
        }
    }
}

