package com.flybits.commons.library.exceptions

/**
 * The exception is thrown when the user attempts to call the [Device] APIs related to
 * adding/removing unique identifiers associated to the Flybits Device. This can including unique
 * identifiers related to 3rd Party systems such as SalesForce, Adobe, etc. and is used to groups a
 * set of Ids under a single device.
 *
 * See [com.flybits.commons.library.models.Device.deleteAssociation] and
 * [com.flybits.commons.library.models.Device.addAssociation]
 */
class NoDeviceIDSetException : FlybitsException("It appears that you do not have a device ID set. " +
        "The only way to get a Device ID is you call the FlybitsManager.connect(...) function.")