/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.SecuredSharedElements;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.logging.Logger;
import com.flybits.internal.db.UserDAO;
import devliving.online.securedpreferencestore.EncryptionManager;
import devliving.online.securedpreferencestore.SecuredPreferenceStore;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u001d\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0015J$\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/flybits/commons/library/SecuredSharedElements;", "Lcom/flybits/commons/library/SharedElements;", "securedPreferenceStore", "Ldevliving/online/securedpreferencestore/SecuredPreferenceStore;", "userDAO", "Lcom/flybits/internal/db/UserDAO;", "(Ldevliving/online/securedpreferencestore/SecuredPreferenceStore;Lcom/flybits/internal/db/UserDAO;)V", "decodeEncryptedText", "Ldevliving/online/securedpreferencestore/EncryptionManager$EncryptedData;", "text", "", "decrypt", "encryptionManager", "Ldevliving/online/securedpreferencestore/EncryptionManager;", "migrateV1", "", "oldUnencryptedPreferences", "Landroid/content/SharedPreferences;", "migrateV1$commons_release", "migrateV2", "oldPreferences", "migrateV2$commons_release", "projectId", "context", "Landroid/content/Context;", "performMigration", "args", "", "setStringVariable", "", "key", "value", "commons_release"})
public final class SecuredSharedElements
extends SharedElements {
    private final SecuredPreferenceStore securedPreferenceStore;

    @Override
    protected int performMigration(@NotNull Context context, @NotNull Map<String, String> args) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        String string = args.get("flybits_arg_project_id");
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("Missing project id from argument map. Include ARG_PROJECT_ID.");
        }
        String projectId = string;
        int migratedValues = 0;
        SharedPreferences sharedPreferences = context.getSharedPreferences("FLYBITS_PREF", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ODE_PRIVATE\n            )");
        migratedValues += this.migrateV1$commons_release(sharedPreferences);
        return migratedValues += this.migrateV2$commons_release(projectId, context);
    }

    public final int migrateV2$commons_release(@NotNull String projectId, @NotNull Context context) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = SharedElements.Companion.getTAG$commons_release();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        Logger.appendTag(string).d("migrate() projectId: " + projectId);
        try {
            SharedPreferences oldPreferences = context.getSharedPreferences("flybits_con_storage", 0);
            EncryptionManager encryptionManager2 = new EncryptionManager(context, oldPreferences, projectId, null, (SecuredPreferenceStore.KeyStoreRecoveryNotifier)migrateV2.encryptionManager.1.INSTANCE);
            SharedPreferences sharedPreferences = oldPreferences;
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"oldPreferences");
            n = this.migrateV2$commons_release(encryptionManager2, sharedPreferences);
        }
        catch (Exception e) {
            Logger.e("SecuredSharedElements.migrateV2() error: " + e.getMessage());
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int migrateV2$commons_release(@NotNull EncryptionManager encryptionManager2, @NotNull SharedPreferences oldPreferences) {
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"com/flybits/commons/library/SecuredSharedElements$migrateV2$Key", "", "hashed", "", "unhashed", "(Ljava/lang/String;Ljava/lang/String;)V", "getHashed", "()Ljava/lang/String;", "getUnhashed", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lcom/flybits/commons/library/SecuredSharedElements$migrateV2$Key;", "equals", "", "other", "hashCode", "", "toString", "commons_release"})
        public final class Key {
            @NotNull
            private final String hashed;
            @NotNull
            private final String unhashed;

            @NotNull
            public final String getHashed() {
                return this.hashed;
            }

            @NotNull
            public final String getUnhashed() {
                return this.unhashed;
            }

            public Key(@NotNull String hashed, @NotNull String unhashed) {
                Intrinsics.checkParameterIsNotNull((Object)hashed, (String)"hashed");
                Intrinsics.checkParameterIsNotNull((Object)unhashed, (String)"unhashed");
                this.hashed = hashed;
                this.unhashed = unhashed;
            }

            @NotNull
            public final String component1() {
                return this.hashed;
            }

            @NotNull
            public final String component2() {
                return this.unhashed;
            }

            @NotNull
            public final Key copy(@NotNull String hashed, @NotNull String unhashed) {
                Intrinsics.checkParameterIsNotNull((Object)hashed, (String)"hashed");
                Intrinsics.checkParameterIsNotNull((Object)unhashed, (String)"unhashed");
                return new Key(hashed, unhashed);
            }

            public static /* synthetic */ Key copy$default(Key key, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = key.hashed;
                }
                if ((n & 2) != 0) {
                    string2 = key.unhashed;
                }
                return key.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Key(hashed=" + this.hashed + ", unhashed=" + this.unhashed + ")";
            }

            public int hashCode() {
                String string = this.hashed;
                String string2 = this.unhashed;
                return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Key)) break block3;
                        Key key = (Key)object;
                        if (!Intrinsics.areEqual((Object)this.hashed, (Object)key.hashed) || !Intrinsics.areEqual((Object)this.unhashed, (Object)key.unhashed)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)encryptionManager2, (String)"encryptionManager");
        Intrinsics.checkParameterIsNotNull((Object)oldPreferences, (String)"oldPreferences");
        SecuredPreferenceStore.Editor editor = SecuredPreferenceStore.getSharedInstance().edit();
        boolean bl = false;
        boolean bl2 = false;
        SecuredPreferenceStore.Editor $this$apply = editor;
        boolean bl3 = false;
        int migratedCount = 0;
        Iterable $this$map$iv = SetsKt.setOf((Object[])new String[]{"com.flybits.jwt.token", "com.flybits.language.codes", "com.flybits.idp.connected", "com.flybits.project.id"});
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            String string2 = EncryptionManager.getHashed((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"EncryptionManager.getHashed(it)");
            Key key = new Key(string2, (String)it);
            collection.add(key);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Key it = (Key)element$iv;
            boolean bl5 = false;
            if (oldPreferences.getString(it.getHashed(), null) == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            String encryptedValue = string;
            boolean bl8 = false;
            String decryptedValue = this.decrypt(encryptedValue, encryptionManager2);
            $this$apply.putString(it.getUnhashed(), decryptedValue);
            oldPreferences.edit().remove(it.getHashed()).apply();
            int n = migratedCount;
            migratedCount = n + 1;
        }
        $this$apply.apply();
        String string = SharedElements.Companion.getTAG$commons_release();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        Logger.appendTag(string).d("migrateV2() migrated " + migratedCount + " values to V2.");
        return migratedCount;
    }

    private final EncryptionManager.EncryptedData decodeEncryptedText(String text) {
        List list;
        CharSequence charSequence = text;
        String string = "]";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        byte[] mac = null;
        if (parts.length > 2) {
            mac = EncryptionManager.base64Decode((String)parts[2]);
        }
        return new EncryptionManager.EncryptedData(EncryptionManager.base64Decode((String)parts[0]), EncryptionManager.base64Decode((String)parts[1]), mac);
    }

    private final String decrypt(String text, EncryptionManager encryptionManager2) throws IOException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, EncryptionManager.InvalidMacException, NoSuchProviderException, InvalidAlgorithmParameterException, KeyStoreException, UnrecoverableEntryException {
        if (text != null && text.length() > 0) {
            EncryptionManager.EncryptedData encryptedData = this.decodeEncryptedText(text);
            byte[] decrypted = encryptionManager2.tryDecrypt(encryptedData);
            Intrinsics.checkExpressionValueIsNotNull((Object)decrypted, (String)"decrypted");
            byte[] byArray = decrypted;
            int n = 0;
            int n2 = decrypted.length;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
            Charset charset2 = charset;
            boolean bl = false;
            return new String(byArray, n, n2, charset2);
        }
        return null;
    }

    public final int migrateV1$commons_release(@NotNull SharedPreferences oldUnencryptedPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)oldUnencryptedPreferences, (String)"oldUnencryptedPreferences");
        String string = SharedElements.Companion.getTAG$commons_release();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        Logger.appendTag(string).d("migrateV1()");
        int migratedValues = 0;
        if (oldUnencryptedPreferences.contains("com.flybits.idp.connected")) {
            String string2 = oldUnencryptedPreferences.getString("com.flybits.idp.connected", "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"oldUnencryptedPreference\u2026g(PREF_IDP_CONNECTED, \"\")");
            this.setStringVariable("com.flybits.idp.connected", string2);
            ++migratedValues;
        }
        if (oldUnencryptedPreferences.contains("com.flybits.project.id")) {
            String string3 = oldUnencryptedPreferences.getString("com.flybits.project.id", "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"oldUnencryptedPreference\u2026ring(PREF_PROJECT_ID, \"\")");
            this.setStringVariable("com.flybits.project.id", string3);
            ++migratedValues;
        }
        if (oldUnencryptedPreferences.contains("com.flybits.language.codes")) {
            String string4 = oldUnencryptedPreferences.getString("com.flybits.language.codes", "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"oldUnencryptedPreference\u2026(PREF_LANGUAGE_CODES, \"\")");
            this.setStringVariable("com.flybits.language.codes", string4);
            ++migratedValues;
        }
        if (oldUnencryptedPreferences.contains("com.flybits.jwt.token")) {
            String string5 = oldUnencryptedPreferences.getString("com.flybits.jwt.token", "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"oldUnencryptedPreference\u2026tring(PREF_JWT_TOKEN, \"\")");
            this.setStringVariable("com.flybits.jwt.token", string5);
            ++migratedValues;
        }
        if (migratedValues > 0) {
            oldUnencryptedPreferences.edit().clear().apply();
        }
        return migratedValues;
    }

    @Override
    public void setStringVariable(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(key, value);
        editor.apply();
    }

    public SecuredSharedElements(@NotNull SecuredPreferenceStore securedPreferenceStore, @NotNull UserDAO userDAO) {
        Intrinsics.checkParameterIsNotNull((Object)securedPreferenceStore, (String)"securedPreferenceStore");
        Intrinsics.checkParameterIsNotNull((Object)userDAO, (String)"userDAO");
        super((SharedPreferences)securedPreferenceStore, userDAO);
        this.securedPreferenceStore = securedPreferenceStore;
    }
}

