/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.idps;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.api.idps.HttpMethod;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidProjectIDException;
import com.flybits.commons.library.exceptions.MissingProjectIDException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class IDP
implements Parcelable {
    private String provider;
    private static final String TAG_LOGGING = "IDP";

    public IDP(String provider) {
        this.provider = provider;
    }

    public IDP(Parcel in) {
        this.provider = in.readString();
    }

    public abstract String getAuthenticationEndPoint();

    public HttpMethod getRequestType() {
        return HttpMethod.POST;
    }

    public HashMap<String, String> getHeaders() {
        return new HashMap<String, String>();
    }

    public static String getProjectID(Context mContext) throws MissingProjectIDException {
        Logger.appendTag(TAG_LOGGING).i("Getting project ID");
        SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(mContext);
        String savedProjectId = sharedElements.getProjectID();
        String projectID = null;
        try {
            ApplicationInfo ai = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            if (bundle.containsKey("com.flybits.projectID")) {
                projectID = bundle.getString("com.flybits.projectID");
                sharedElements.setProjectID(projectID);
                Logger.appendTag(TAG_LOGGING).i("Found project ID in AndroidManifest.xml - " + projectID);
            } else {
                Logger.appendTag(TAG_LOGGING).i("Could not find project ID in AndroidManifest.xml file");
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.appendTag(TAG_LOGGING).e("There was an issue with retrieving project ID from AndroidManifest.xml", (Exception)e);
        }
        if ((savedProjectId == null || savedProjectId.length() == 0) && projectID == null) {
            Logger.appendTag(TAG_LOGGING).e("Could not find a previously saved Project ID or the project ID is Null");
            throw new MissingProjectIDException("Your Flybits ProjectID has not been set. Please make sure you set it within the AndroidManifest.xml file under the meta key: 'com.flybits.projectID'");
        }
        if (savedProjectId != null && savedProjectId.length() > 0 && projectID != null && !savedProjectId.equalsIgnoreCase(projectID)) {
            Logger.appendTag(TAG_LOGGING).e("Found a previously saved project ID which is different than the one that is currently being set.");
            throw new InvalidProjectIDException("It appears you are trying to access Flybits with a different Project ID than the logged in user. Try uninstalling the application correctly and re-running it to login successfully.");
        }
        if (savedProjectId != null && savedProjectId.length() > 0) {
            Logger.appendTag(TAG_LOGGING).e("Returning previously saved project ID: " + savedProjectId);
            return savedProjectId;
        }
        Logger.appendTag(TAG_LOGGING).e("Returning new project ID: " + projectID);
        return projectID;
    }

    public String getProvider() {
        return this.provider;
    }

    public JSONObject getRequestBody(Context context) throws MissingProjectIDException, FlybitsException {
        return this.getRequestBody(context, true);
    }

    public JSONObject getRequestBody(Context mContext, boolean autoUseProjectId) throws MissingProjectIDException, FlybitsException {
        JSONObject bodyObject = this.getBody();
        if (bodyObject == null) {
            bodyObject = new JSONObject();
        }
        if (!autoUseProjectId) {
            Logger.appendTag(TAG_LOGGING).i("autoUseProjectId was set to false");
            Logger.appendTag(TAG_LOGGING).i("IDP Request: " + bodyObject.toString());
            return bodyObject;
        }
        try {
            bodyObject.put("projectId", (Object)IDP.getProjectID(mContext));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        Logger.appendTag(TAG_LOGGING).i("IDP Request: " + bodyObject.toString());
        return bodyObject;
    }

    public abstract JSONObject getBody() throws FlybitsException;

    public void onAuthenticated(Context context, @NotNull User user) {
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.provider);
    }
}

