package com.flybits.commons.library.logging

/**
 * A list of verbosity levels that are currently supported by the SDK. Based on these verbosity
 * levels, logs will be displayed in the logcat according to the application developer's preference.
 *
 * @param The integer value representing the verbosity level.
 */
enum class VerbosityLevel(val level : Int){

    /**
     * Indicates that all logs should be displayed
     */
    ALL(6),

    /**
     * Indicates that only exceptions that would crash the application should be displayed.
     */
    FATAL(1),

    /**
     * Indicates that something unexpected has occurred in the SDK and the developer should be
     * notified. This should be add to a log when the SDK receives invalid data from the application
     * or the Flybits server.
     */
    ERROR(2),

    /**
     * Indicates that something unwanted might occur as a result of an input in the SDK, this is
     * usually due to an invalid value being passed to the SDK.
     */
    WARNINGS(3),

    /**
     * Indicates information for the developer in the logcat that might be of interest to them. One
     * example of this should be when the application successfully connects to Flybits.
     */
    INFO(4),

    /**
     * Indicates that even Flybits developer logs should be displayed in the logcat. This is useful
     * for creating breakcrumbs that indicates how the SDK is being used by the developer. This
     * [VerbosityLevel] should not be used for production apps.
     */
    DEBUG(5),

    /**
     * Indicates that no logs should be displayed in the logcat.
     */
    NONE(0)
}