package com.flybits.commons.library.exceptions


/**
 *  The {@code NetworkResponseException} is thrown when an api call is returned with not found status code.
 *  This means that the specific api call is either wrong or not present for that user and project
 */
class NetworkResponseException: FlybitsException{

    /**
     * Constructs a new [NetworkResponseException] with a generic message
     */
    constructor() : super("The network request has encountered an unknown error.")

    /**
     * Constructs a new [NetworkResponseException] with a generic message
     */
    constructor(method : String) : super("The network request has encountered an unknown error - $method.")

    /**
     * Constructs a new [NetworkResponseException] with error code
     *
     * @param errorCode the error code for this exception.
     */
    constructor(errorCode: Int): super("There was an error while making your network request" , errorCode)

    /**
     * Constructs a new [NetworkResponseException] with error code and error message
     *
     * @param errorCode the error code for this exception.
     */
    constructor(errorCode: Int, message: String): super("Server Error : $message", errorCode)
}