package com.flybits.commons.library.api.results.callbacks

/**
 * Callback used to indicate whether or not a network query that returns a list of items was
 * successful or not.
 *
 * @param <T> The item type that is expected to be returned as a list.
 */
interface ListResultCallback<T> : BaseCallback {

    /**
     * Indicates that the request was successfully made.
     *
     * @param items The items that are expected to be returned.
     */
    fun onSuccess(items : ArrayList<T>)
}