package com.flybits.commons.library

import com.flybits.commons.library.exceptions.InvalidPhysicalDeviceIdException
import com.google.android.gms.ads.identifier.AdvertisingIdClient
import com.google.android.gms.common.GooglePlayServicesNotAvailableException
import com.google.android.gms.common.GooglePlayServicesRepairableException
import java.io.IOException

/**
 * Default implementation for generating unique physical device id
 * Using Google's Advertising Id as the unique id
 *
 * @param advertisingIdClientInfo client to fetch the advertising Id
 */
internal class DefaultUniqueDeviceIdGenerator(private val advertisingIdClientInfo: AdvertisingIdClient.Info) : UniqueDeviceIdGenerator {

    /*
     * @throws InvalidPhysicalDeviceIdException when the Google Advertising Id could not be obtained
     * successfully.
     */
    @Throws (InvalidPhysicalDeviceIdException::class)
    override fun generateUniqueDeviceId(): String{

        try {
            return advertisingIdClientInfo.id
        } catch(ioException : IOException) {
            throw InvalidPhysicalDeviceIdException("Error accessing Google Play Services")
        } catch (illegalStateException : IllegalStateException) {
            throw InvalidPhysicalDeviceIdException("Error accessing Google Play Services Unique Id from main thread")
        } catch (googlePlayServicesNotAvailableException : GooglePlayServicesNotAvailableException) {
            throw InvalidPhysicalDeviceIdException("Google Play Services is not installed on device")
        } catch (googlePlayServicesRepairableException : GooglePlayServicesRepairableException) {
            throw InvalidPhysicalDeviceIdException("Google Play Services not installed, not updated or not enabled")
        }
    }

}