package com.flybits.commons.library.models

import android.arch.persistence.room.ColumnInfo
import android.arch.persistence.room.Entity
import android.arch.persistence.room.PrimaryKey

/**
 * This class represents a piece of ctx data with an id, timestamp and value. It can be used
 * for storing a version of an object in json string format prior to sending it to the server.
 *
 * @param timestamp Store in milliseconds in local database to help in sorting, retrieving.
 *
 */
@Entity(tableName = "ctxData")
data class CtxData(@ColumnInfo(name = "id") @PrimaryKey(autoGenerate = true) var id: Long = 0
                   , @ColumnInfo(name = "timestamp") val timestamp: Long
                   , @ColumnInfo(name = "value") val value: String)