package com.flybits.commons.library.exceptions


/**
 *  The {@code NetworkResponseException} is thrown when an api call is returned with not found status code.
 *  This means that the specific api call is either wrong or not present for that user and project
 */
class NetworkResponseException: FlybitsException{

    /**
     * Constructs a new [NetworkResponseException] with a generic message
     *
     */
    constructor() : super("Server Error")

    /**
     * Constructs a new [NetworkResponseException] with error code
     *
     * @param errorCode the error code for this exception.
     */
    constructor(errorCode: Int): super("Server Error" , errorCode)

    /**
     * Constructs a new [NetworkResponseException] with error code and error message
     *
     * @param errorCode the error code for this exception.
     */
    constructor(errorCode: Int, message: String): super("Server Error : $message", errorCode)
}