package com.flybits.commons.library.api.idps;


import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONObject;

/**
 * The {@code AnonymousIDP} class is responsible for logging into the Flybits system anonymously
 * without having to enter any additional information. This IDP is the default IDP for the Android
 * SDK. It can be overridden by other IDPs such as {@link FlybitsIDP}.
 */
public class AnonymousIDP extends IDP{

    private static final String ENDPOINT       = "/anonymous";

    /**
     * Constructor used to register an anonymous account to the Flybits system.
     */
    public AnonymousIDP(){
        super ("anonymous");
    }

    private AnonymousIDP(Parcel in) {
        super(in);
    }

    @Override
    public String getAuthenticationEndPoint() {
        return ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        return null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
    }

    public static final Parcelable.Creator<AnonymousIDP> CREATOR = new Creator<AnonymousIDP>() {
        @Override
        public AnonymousIDP createFromParcel(Parcel in) {
            return new AnonymousIDP(in);
        }

        @Override
        public AnonymousIDP[] newArray(int size) {
            return new AnonymousIDP[size];
        }
    };
}
