/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.QueryStatus;
import com.flybits.commons.library.api.results.callbacks.ListResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;

public class ListResult<T>
extends FlybitsResult {
    private ArrayList<T> object;
    private ListResultCallback<T> callback;
    private Handler handler;

    public ListResult(@NonNull Context context, ListResultCallback<T> callback) {
        super(context);
        this.callback = callback;
    }

    public ListResult(@NonNull Context context, ListResultCallback<T> callback, @NonNull ExecutorService service, @NonNull Handler handler) {
        super(context, service);
        this.callback = callback;
        this.handler = handler;
    }

    public ArrayList<T> getResult() {
        if (this.getStatus() == QueryStatus.SUCCESS) {
            return this.object;
        }
        return null;
    }

    @Override
    public boolean setFailed(final FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                if (this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ListResult.this.callback.onException(e);
                        }
                    });
                } else {
                    this.callback.onException(e);
                }
            }
            return true;
        }
        return false;
    }

    public void setSuccess(final @NonNull ArrayList<T> result) {
        if (this.setSuccess()) {
            this.object = result;
            if (this.callback != null) {
                if (this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ListResult.this.callback.onSuccess(result);
                        }
                    });
                } else {
                    this.callback.onSuccess(result);
                }
            }
        }
    }

    public void setResult(@NonNull Result<ArrayList<T>> result) {
        if (result.getStatus() == RequestStatus.COMPLETED) {
            this.setSuccess(result.getResult());
        } else {
            this.setFailed(result.getException());
        }
    }
}

