package com.flybits.commons.library.logging;


import android.support.annotation.NonNull;
import android.util.Log;

import static com.flybits.commons.library.api.FlybitsManager.IS_DEBUG;

/**
 * The {@code Displayer} class is used to display information within the logcat.
 */
public class Displayer {

    private String tag;

    Displayer(String tag){
        this.tag    = tag;
    }

    /**
     * Change the tag for which the information is logged under within the logcat.
     *
     * @param tag The {@code tag} to set for information to be displayed under.
     * @return The {@code Displayer} class that is used to display information within the logcat.
     */
    public Displayer changeTag(String tag){
        this.tag    = tag;
        return this;
    }

    /**
     * Get the tag that logcat information should be displayed under.
     *
     * @return The information tag that is used to characterize information under the logcat.
     */
    public String getTag(){
        return tag;
    }

    /**
     * Creates a log statement in the logcat that displays information used to debug the Flybits
     * SDK.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public void d(@NonNull String msg){
        if (IS_DEBUG) {
            Log.d(tag, msg);
        }
    }

    /**
     * Creates a log statement in the logcat that displays an error.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public void e(@NonNull String msg){
        if (IS_DEBUG) {
            Log.e(tag, msg);
        }
    }

    /**
     * Creates a log statement in the logcat that displays some information.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public void i(@NonNull String msg){
        if (IS_DEBUG) {
            Log.i(tag, msg);
        }
    }

    /**
     * Creates a log statement in the logcat that displays a warning.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public void w(@NonNull String msg){
        if (IS_DEBUG) {
            Log.w(tag, msg);
        }
    }

    void exception(@NonNull Exception e){
        if (IS_DEBUG) {
            e.printStackTrace();
        }
    }
}
