/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;

public class BasicResult
extends FlybitsResult {
    private BasicResultCallback callback;
    private Handler handler;

    public BasicResult(@NonNull Context context, BasicResultCallback callback) {
        super(context);
        this.callback = callback;
    }

    public BasicResult(@NonNull Context context, BasicResultCallback callback, @NonNull ExecutorService service, @NonNull Handler handler) {
        super(context, service);
        this.callback = callback;
        this.handler = handler;
    }

    @Override
    public boolean setFailed(final FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                if (this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BasicResult.this.callback.onException(e);
                        }
                    });
                } else {
                    this.callback.onException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setSuccess() {
        if (super.setSuccess()) {
            if (this.callback != null) {
                if (this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BasicResult.this.callback.onSuccess();
                        }
                    });
                } else {
                    this.callback.onSuccess();
                }
            }
            return true;
        }
        return false;
    }

    public void setResult(@NonNull Result result) {
        if (result.getStatus() == RequestStatus.COMPLETED) {
            this.setSuccess();
        } else {
            this.setFailed(result.getException());
        }
    }
}

