/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models.internal;

import com.flybits.commons.library.deserializations.DeserializeNetworkError;
import com.flybits.commons.library.exceptions.APIUsageExceededException;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.NotConnectedException;
import com.flybits.commons.library.http.RequestStatus;

public class Result<T> {
    private T response;
    private FlybitsException exception;
    private RequestStatus responseStatus;
    private String responseAsString;

    public Result(int code, String body2) {
        this.setRequestStatus(code, body2);
    }

    public Result(FlybitsException exception, String response) {
        if (response != null) {
            this.responseAsString = response;
        }
        this.responseStatus = RequestStatus.FAILED;
        this.exception = exception;
    }

    public FlybitsException getException() {
        return this.exception;
    }

    public T getResult() {
        return this.response;
    }

    public String getResultAsString() {
        return this.responseAsString;
    }

    public RequestStatus getStatus() {
        return this.responseStatus;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    private void setRequestStatus(int code, String response) {
        this.responseAsString = response;
        if (code >= 200 && code < 300) {
            this.responseStatus = RequestStatus.COMPLETED;
        } else if (code == 401) {
            this.responseStatus = RequestStatus.NOT_CONNECTED;
            this.exception = new NotConnectedException(response);
        } else if (code == 404) {
            this.responseStatus = RequestStatus.NOT_FOUND;
            this.exception = new FlybitsException(response);
        } else if (code == 429) {
            this.responseStatus = RequestStatus.API_USAGE_EXCEEDED;
            this.exception = new APIUsageExceededException("Your API quota limit has been reached. Please contact support@flybits.com to increase your quota.");
        } else {
            this.responseStatus = RequestStatus.FAILED;
            this.exception = new DeserializeNetworkError().fromJson(response);
            if (this.exception == null) {
                this.exception = new FlybitsException(response);
            }
        }
    }
}

