/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;

public class ConnectionResult
extends FlybitsResult {
    private ConnectionResultCallback callback;
    private Handler handler;

    public ConnectionResult(Context context, ConnectionResultCallback callback) {
        super(context);
        this.callback = callback;
    }

    public ConnectionResult(Context context, ConnectionResultCallback callback, ExecutorService service, @NonNull Handler handler) {
        super(context, service);
        this.callback = callback;
        this.handler = handler;
    }

    @Override
    public boolean setFailed(final FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                if (this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionResult.this.callback.onException(e);
                        }
                    });
                } else {
                    this.callback.onException(e);
                }
            }
            return true;
        }
        return false;
    }

    public void setConnected() {
        if (this.setSuccess() && this.callback != null) {
            if (this.handler != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionResult.this.callback.onConnected();
                    }
                });
            } else {
                this.callback.onConnected();
            }
        }
    }

    public void setNotConnected() {
        if (this.setSuccess() && this.callback != null) {
            if (this.handler != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionResult.this.callback.notConnected();
                    }
                });
            } else {
                this.callback.notConnected();
            }
        }
    }

    public void setResult(Result result) {
        if (result.getStatus() == RequestStatus.COMPLETED) {
            this.setConnected();
        } else {
            this.setFailed(result.getException());
        }
    }
}

