package com.flybits.commons.library.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.commons.library.api.FlybitsManager;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.Project;
import com.flybits.commons.library.utils.ProjectParameters;
import com.flybits.commons.library.models.internal.QueryParameters;

import java.util.concurrent.ExecutorService;

/**
 * This class holds the last state of a request when getting {@code Project}s. This allows for pagination
 * state to be used for getting more items.
 */
public class ProjectsResult extends PagedResult<Project> {

    private FlybitsManager mManager;

    /**
     * Instantiates a {@code Result} object.
     * @param context An Android context.
     * @param callback The callback that was used for the request.
     * @param manager The {@code FlybitsManager} used for the request.
     */
    public ProjectsResult(Context context, PagedResultCallback<Project> callback, FlybitsManager manager)
    {
        super(context, callback);
        mManager = manager;
    }

    /**
     * Instantiates a {@code Result} object.
     * @param context An Android context.
     * @param callback The callback that was used for the request.
     * @param manager The {@code FlybitsManager} used for the request.
     * @param service The {@code ExecutorService} used for the request.
     */
    public ProjectsResult(Context context, PagedResultCallback<Project> callback, FlybitsManager manager, ExecutorService service)
    {
        super(context, callback, service);
        mManager = manager;
    }

    /**
     * Instantiates a {@code Result} object.
     * @param context An Android context.
     * @param callback The callback that was used for the request.
     */
    public ProjectsResult(Context context, PagedResultCallback<Project> callback){
        super(context, callback);
    }

    /**
     * Instantiates a {@code Result} object.
     * @param context An Android context.
     * @param callback The callback that was used for the request.
     * @param service The {@code ExecutorService} used for the request.
     */
    public ProjectsResult(Context context, PagedResultCallback<Project> callback, ExecutorService service){
        super(context, callback, service);
    }

    /**
     * Instantiates a {@code Result} object.
     * @param context An Android context.
     * @param parameters {@link ProjectParameters} The parameters that are part of the request.
     * @param callback The callback that was used for the request.
     * @param service The {@code ExecutorService} used for the request.
     * @param handler The handler which indicates the Main UI thread to run code under.
     */
    public ProjectsResult(Context context, ProjectParameters parameters, PagedResultCallback<Project> callback, ExecutorService service, Handler handler){
        super(context, parameters, callback, service, handler);
    }

    /**
     * Runs getProjects() again with the same parameters used before, but with the offset updated to
     * get the next paged results.
     * @param context The context of the application.
     * @param parameters The {@link QueryParameters}, if any, that that indicate any additional
     *                   filters used for this network request.
     * @param callback The {@link PagedResultCallback} that indicates whether or not more items where
     * @return Another result, with the next returned objects.
     */
    @Override
    protected <K extends QueryParameters> PagedResult getMore(Context context, K parameters, PagedResultCallback<Project> callback) {
        return mManager.getProjects((ProjectParameters) parameters, callback);
    }

}
