/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.models.preferences;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.Preference;
import com.flybits.internal.models.preferences.FlybitsPreferences;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class FlybitsFavourite
extends FlybitsPreferences {
    public FlybitsFavourite(Context context) {
        super(context, new Handler(Looper.getMainLooper()));
    }

    public FlybitsFavourite(Context context, Handler handler) {
        super(context, handler);
    }

    public void add(final String key, final String value, final BasicResultCallback callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (FlybitsFavourite.this.containsDB(key, value)) {
                    if (FlybitsFavourite.this.getHandler() != null) {
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess();
                            }
                        });
                    }
                    return;
                }
                Preference preference = new Preference(key, value);
                CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().insert(preference);
                List<String> listOfItemsSaved = CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().getIdsByKey(key);
                JSONArray jsonArray = new JSONArray();
                for (String value2 : listOfItemsSaved) {
                    jsonArray.put((Object)value2);
                }
                final Result result = FlybitsFavourite.this.update(key, jsonArray);
                if (FlybitsFavourite.this.getHandler() != null) {
                    if (result.getStatus() == RequestStatus.COMPLETED) {
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess();
                            }
                        });
                    } else {
                        CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().deleteByKeyAndValue(preference.getPrefKey(), preference.getValue());
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onException(result.getException());
                            }
                        });
                    }
                }
            }
        });
    }

    public void remove(final String key, final String value, final BasicResultCallback callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (!FlybitsFavourite.this.containsDB(key, value)) {
                    if (FlybitsFavourite.this.getHandler() != null) {
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess();
                            }
                        });
                    }
                    return;
                }
                CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().deleteByKeyAndValue(key, value);
                List<String> listOfItemsSaved = CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().getIdsByKey(key);
                JSONArray jsonArray = new JSONArray();
                for (String value2 : listOfItemsSaved) {
                    jsonArray.put((Object)value2);
                }
                final Result result = FlybitsFavourite.this.update(key, jsonArray);
                if (FlybitsFavourite.this.getHandler() != null) {
                    if (result.getStatus() == RequestStatus.COMPLETED) {
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess();
                            }
                        });
                    } else {
                        Preference preference = new Preference(key, value);
                        CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().insert(preference);
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onException(result.getException());
                            }
                        });
                    }
                }
            }
        });
    }

    public void clear(final String key, final BasicResultCallback callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                FlybitsFavourite.this.putStringList(key, new ArrayList<String>(), new BasicResultCallback(){

                    @Override
                    public void onSuccess() {
                        CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().deleteByPrefKey(key);
                        if (callback != null && FlybitsFavourite.this.getHandler() != null) {
                            FlybitsFavourite.this.getHandler().post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onSuccess();
                                }
                            });
                        }
                    }

                    @Override
                    public void onException(final FlybitsException exception) {
                        if (callback != null && FlybitsFavourite.this.getHandler() != null) {
                            FlybitsFavourite.this.getHandler().post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onException(exception);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private boolean containsDB(String key, String value) {
        return CommonsDatabase.getDatabase(this.getContext()).preferenceDAO().getIdsByKeyAndValue(key, value).size() > 0;
    }

    public void containsDB(final String key, final String value, final @NonNull ObjectResultCallback<Boolean> callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    final List<Preference> items = CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().getIdsByKeyAndValue(key, value);
                    if (FlybitsFavourite.this.getHandler() != null) {
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess(items.size() > 0);
                            }
                        });
                    }
                }
            }
        });
    }

    public void getFromDB(final String key, final @NonNull ObjectResultCallback<List<String>> callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    final List<String> items = CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().getIdsByKey(key);
                    if (FlybitsFavourite.this.getHandler() != null) {
                        FlybitsFavourite.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess(items);
                            }
                        });
                    }
                }
            }
        });
    }

    public void getFromServer(String key, @NonNull ObjectResultCallback<ArrayList<String>> callback) {
        this.getStringList(key, callback);
    }

    public void reset(final String key, final ObjectResultCallback<ArrayList<String>> callback) {
        this.getStringList(key, new ObjectResultCallback<ArrayList<String>>(){

            @Override
            public void onSuccess(final ArrayList<String> items) {
                FlybitsFavourite.this.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().deleteByPrefKey(key);
                        ArrayList<Preference> listOfPreferences = new ArrayList<Preference>();
                        for (String item : items) {
                            listOfPreferences.add(new Preference(key, item));
                        }
                        CommonsDatabase.getDatabase(FlybitsFavourite.this.getContext()).preferenceDAO().insert(listOfPreferences);
                        if (callback != null && FlybitsFavourite.this.getHandler() != null) {
                            FlybitsFavourite.this.getHandler().post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onSuccess(items);
                                }
                            });
                        }
                    }
                });
            }

            @Override
            public void onException(final FlybitsException exception) {
                if (callback != null && FlybitsFavourite.this.getHandler() != null) {
                    FlybitsFavourite.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onException(exception);
                        }
                    });
                }
            }
        });
    }
}

