/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.android;

import com.flurry.sdk.cx;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Consent {
    public static final String GPP_STRING_KEY = "gpp";
    public static final String GPP_SID_KEY = "gppSid";
    protected boolean isGdprScope;
    protected Map<String, String> consentStrings;

    public boolean isGdprScope() {
        return this.isGdprScope;
    }

    public Map<String, String> getConsentStrings() {
        return this.consentStrings;
    }

    public String getGppString() {
        if (this.isGdprScope || this.consentStrings == null || !this.consentStrings.containsKey(GPP_STRING_KEY)) {
            return null;
        }
        return this.consentStrings.get(GPP_STRING_KEY);
    }

    public Set<Integer> getGppSectionIds() {
        if (this.isGdprScope || this.consentStrings == null || !this.consentStrings.containsKey(GPP_SID_KEY)) {
            return null;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        String string = this.consentStrings.get(GPP_SID_KEY);
        try {
            Matcher matcher = Pattern.compile("\\d+").matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group();
                try {
                    hashSet.add(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    cx.b("Consent", "Invalid GPP section Id: ".concat(String.valueOf(string2)));
                }
            }
        }
        catch (Throwable throwable) {
            cx.b("Consent", "Invalid GPP section Ids: ".concat(String.valueOf(string)));
        }
        return hashSet;
    }

    public String idsToString(Set<Integer> object) {
        if (object == null || object.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (true) {
            stringBuilder.append(object.next());
            if (!object.hasNext()) {
                return stringBuilder.toString();
            }
            stringBuilder.append(',');
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.isGdprScope == ((Consent)(object = (Consent)object)).isGdprScope() && (this.consentStrings != null ? this.consentStrings.equals(((Consent)object).getConsentStrings()) : ((Consent)object).getConsentStrings() == null);
    }

    public int hashCode() {
        int n2 = this.isGdprScope ? 1 : 0;
        return 31 * n2 + (this.consentStrings != null ? this.consentStrings.hashCode() : 0);
    }
}

