/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.di;

import com.fitbur.testify.di.ServiceDescriptor;
import com.fitbur.testify.di.ServiceScope;

public class ServiceDescriptorBuilder {
    private Class<?> type;
    private String name;
    private ServiceScope scope = ServiceScope.PROTOTYPE;
    private boolean lazy = true;
    private boolean injectable = true;
    private boolean primary = true;
    private Object[] arguments = new Object[0];
    private boolean discoverable;

    public ServiceDescriptorBuilder type(Class<?> clazz) {
        this.type = clazz;
        return this;
    }

    public ServiceDescriptorBuilder name(String string) {
        this.name = string;
        return this;
    }

    public ServiceDescriptorBuilder arguments(Object ... objectArray) {
        this.arguments = objectArray;
        return this;
    }

    public ServiceDescriptorBuilder scope(ServiceScope serviceScope) {
        this.scope = serviceScope;
        return this;
    }

    public ServiceDescriptorBuilder lazy(boolean bl) {
        this.lazy = bl;
        return this;
    }

    public ServiceDescriptorBuilder injectable(boolean bl) {
        this.injectable = bl;
        return this;
    }

    public ServiceDescriptorBuilder discoverable(boolean bl) {
        this.discoverable = bl;
        return this;
    }

    public ServiceDescriptorBuilder primary(boolean bl) {
        this.primary = bl;
        return this;
    }

    public ServiceDescriptor build() {
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor(this.type, this.name, this.scope);
        serviceDescriptor.setArguments(this.arguments);
        serviceDescriptor.setDiscoverable(this.discoverable);
        serviceDescriptor.setInjectable(this.injectable);
        serviceDescriptor.setLazy(this.lazy);
        serviceDescriptor.setPrimary(this.primary);
        return serviceDescriptor;
    }
}

