/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.google;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.firebase.client.Firebase;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.FirebaseOAuthToken;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.core.SocialProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;
import com.firebase.ui.auth.google.GoogleActions;
import com.firebase.ui.auth.google.GoogleOAuthTask;
import com.firebase.ui.auth.google.GoogleOAuthTaskHandler;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;

public class GoogleAuthProvider
extends FirebaseAuthProvider
implements GoogleApiClient.OnConnectionFailedListener,
GoogleApiClient.ConnectionCallbacks,
GoogleOAuthTaskHandler {
    public static final String PROVIDER_NAME = "google";
    public static final SocialProvider PROVIDER_TYPE = SocialProvider.google;
    private final String TAG = "GoogleAuthProvider";
    private GoogleApiClient mGoogleApiClient;
    private TokenAuthHandler mHandler;
    private Activity mActivity;
    private Firebase mRef;
    private Integer onConnectedAction;

    public GoogleAuthProvider(Context context, Firebase ref, TokenAuthHandler handler) {
        FirebaseLoginError error;
        this.mActivity = (Activity)context;
        this.mRef = ref;
        this.mHandler = handler;
        String googleClientId = "";
        try {
            ApplicationInfo ai = this.mActivity.getPackageManager().getApplicationInfo(this.mActivity.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            googleClientId = bundle.getString("com.firebase.ui.GoogleClientId");
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (googleClientId == null) {
            error = new FirebaseLoginError(FirebaseResponse.MISSING_PROVIDER_APP_KEY, "Missing Google client ID, is it set in your AndroidManifest.xml?");
            this.mHandler.onProviderError(error);
            return;
        }
        if (googleClientId.compareTo("") == 0) {
            error = new FirebaseLoginError(FirebaseResponse.INVALID_PROVIDER_APP_KEY, "Invalid Google client ID, is it set in your res/values/strings.xml?");
            this.mHandler.onProviderError(error);
            return;
        }
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestIdToken(googleClientId).requestEmail().build();
        this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this.mActivity).enableAutoManage((FragmentActivity)this.mActivity, (GoogleApiClient.OnConnectionFailedListener)this).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)gso).build();
        this.mGoogleApiClient.connect();
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public Firebase getFirebaseRef() {
        return this.mRef;
    }

    @Override
    public SocialProvider getProviderType() {
        return PROVIDER_TYPE;
    }

    public void onConnected(Bundle bundle) {
        if (this.onConnectedAction == GoogleActions.SIGN_IN) {
            this.login();
        } else if (this.onConnectedAction == GoogleActions.SIGN_OUT) {
            this.logout();
        }
        this.onConnectedAction = 0;
    }

    public void onConnectionSuspended(int i) {
    }

    @Override
    public void logout() {
        if (this.mGoogleApiClient.isConnected()) {
            Auth.GoogleSignInApi.signOut(this.mGoogleApiClient).setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(Status status) {
                    GoogleAuthProvider.this.revokeAccess();
                }
            });
        } else {
            this.onConnectedAction = GoogleActions.SIGN_OUT;
        }
    }

    @Override
    public void login() {
        if (this.mGoogleApiClient.isConnected()) {
            Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(this.mGoogleApiClient);
            this.mActivity.startActivityForResult(signInIntent, GoogleActions.SIGN_IN);
        } else {
            this.onConnectedAction = GoogleActions.SIGN_IN;
        }
    }

    private void revokeAccess() {
        Auth.GoogleSignInApi.revokeAccess(this.mGoogleApiClient).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(Status status) {
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == GoogleActions.SIGN_IN && resultCode == -1) {
            GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
            this.handleSignInResult(result);
        }
        if (requestCode == GoogleActions.SIGN_IN && resultCode == 0) {
            Log.d((String)"GoogleAuthProvider", (String)data.getExtras().keySet().toString());
            this.mHandler.onUserError(new FirebaseLoginError(FirebaseResponse.LOGIN_CANCELLED, "User closed login dialog."));
        }
    }

    private void handleSignInResult(GoogleSignInResult result) {
        if (result.isSuccess()) {
            GoogleSignInAccount acct = result.getSignInAccount();
            acct.getServerAuthCode();
            GoogleOAuthTask googleOAuthTask = new GoogleOAuthTask();
            googleOAuthTask.setContext((Context)this.mActivity);
            googleOAuthTask.setHandler(this);
            googleOAuthTask.execute(new String[]{acct.getEmail()});
        }
    }

    @Override
    public void onOAuthSuccess(String OAuthToken) {
        FirebaseOAuthToken token = new FirebaseOAuthToken(PROVIDER_NAME, OAuthToken);
        this.onFirebaseTokenReceived(token, this.mHandler);
    }

    @Override
    public void onOAuthFailure(FirebaseLoginError firebaseError) {
        this.mHandler.onProviderError(firebaseError);
    }

    public void cleanUp() {
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.disconnect();
            this.mGoogleApiClient.stopAutoManage((FragmentActivity)this.mActivity);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        FirebaseLoginError error = new FirebaseLoginError(FirebaseResponse.MISC_PROVIDER_ERROR, connectionResult.toString());
        this.mHandler.onProviderError(error);
    }
}

