/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.core;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.ui.R;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.SocialProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;
import com.firebase.ui.auth.facebook.FacebookAuthProvider;
import com.firebase.ui.auth.google.GoogleAuthProvider;
import com.firebase.ui.auth.password.PasswordAuthProvider;
import com.firebase.ui.auth.twitter.TwitterAuthProvider;

public class FirebaseLoginDialog
extends DialogFragment {
    FacebookAuthProvider mFacebookAuthProvider;
    TwitterAuthProvider mTwitterAuthProvider;
    GoogleAuthProvider mGoogleAuthProvider;
    PasswordAuthProvider mPasswordAuthProvider;
    TokenAuthHandler mHandler;
    SocialProvider mActiveProvider;
    Firebase mRef;
    Context mContext;
    View mView;

    public void onStop() {
        super.onStop();
        this.cleanUp();
    }

    public void onDestroy() {
        super.onDestroy();
        this.cleanUp();
    }

    public void onPause() {
        super.onPause();
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.mGoogleAuthProvider != null) {
            this.mGoogleAuthProvider.cleanUp();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mFacebookAuthProvider != null) {
            this.mFacebookAuthProvider.mCallbackManager.onActivityResult(requestCode, resultCode, data);
        }
        if (this.mTwitterAuthProvider != null) {
            this.mTwitterAuthProvider.onActivityResult(requestCode, resultCode, data);
        }
        if (this.mGoogleAuthProvider != null) {
            this.mGoogleAuthProvider.onActivityResult(requestCode, resultCode, data);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        this.mView = inflater.inflate(R.layout.fragment_firebase_login, null);
        if (this.mFacebookAuthProvider != null) {
            this.showLoginOption(this.mFacebookAuthProvider, R.id.facebook_button);
        } else {
            this.mView.findViewById(R.id.facebook_button).setVisibility(8);
        }
        if (this.mGoogleAuthProvider != null) {
            this.showLoginOption(this.mGoogleAuthProvider, R.id.google_button);
        } else {
            this.mView.findViewById(R.id.google_button).setVisibility(8);
        }
        if (this.mTwitterAuthProvider != null) {
            this.showLoginOption(this.mTwitterAuthProvider, R.id.twitter_button);
        } else {
            this.mView.findViewById(R.id.twitter_button).setVisibility(8);
        }
        if (this.mPasswordAuthProvider != null) {
            this.showLoginOption(this.mPasswordAuthProvider, R.id.password_button);
            if (this.mFacebookAuthProvider == null && this.mGoogleAuthProvider == null && this.mTwitterAuthProvider == null) {
                this.mView.findViewById(R.id.or_section).setVisibility(8);
            }
        } else {
            this.mView.findViewById(R.id.password_section).setVisibility(8);
        }
        this.mView.findViewById(R.id.loading_section).setVisibility(8);
        builder.setView(this.mView);
        return builder.create();
    }

    public FirebaseLoginDialog setRef(Firebase ref) {
        this.mRef = ref;
        return this;
    }

    public FirebaseLoginDialog setContext(Context context) {
        this.mContext = context;
        return this;
    }

    public void reset() {
        this.mView.findViewById(R.id.login_section).setVisibility(0);
        this.mView.findViewById(R.id.loading_section).setVisibility(8);
    }

    public void logout() {
        if (this.mTwitterAuthProvider != null) {
            this.mTwitterAuthProvider.logout();
        }
        if (this.mFacebookAuthProvider != null) {
            this.mFacebookAuthProvider.logout();
        }
        if (this.mGoogleAuthProvider != null) {
            this.mGoogleAuthProvider.logout();
        }
        if (this.mPasswordAuthProvider != null) {
            this.mPasswordAuthProvider.logout();
        }
        this.mRef.unauth();
    }

    public FirebaseLoginDialog setHandler(final TokenAuthHandler handler) {
        this.mHandler = new TokenAuthHandler(){

            @Override
            public void onSuccess(AuthData auth) {
                FirebaseLoginDialog.this.dismiss();
                handler.onSuccess(auth);
            }

            @Override
            public void onUserError(FirebaseLoginError err) {
                handler.onUserError(err);
            }

            @Override
            public void onProviderError(FirebaseLoginError err) {
                handler.onProviderError(err);
            }
        };
        return this;
    }

    public FirebaseLoginDialog setEnabledProvider(SocialProvider provider) {
        switch (provider) {
            case facebook: {
                if (this.mFacebookAuthProvider != null) break;
                this.mFacebookAuthProvider = new FacebookAuthProvider(this.mContext, this.mRef, this.mHandler);
                break;
            }
            case google: {
                if (this.mGoogleAuthProvider != null) break;
                this.mGoogleAuthProvider = new GoogleAuthProvider(this.mContext, this.mRef, this.mHandler);
                break;
            }
            case twitter: {
                if (this.mTwitterAuthProvider != null) break;
                this.mTwitterAuthProvider = new TwitterAuthProvider(this.mContext, this.mRef, this.mHandler);
                break;
            }
            case password: {
                if (this.mPasswordAuthProvider != null) break;
                this.mPasswordAuthProvider = new PasswordAuthProvider(this.mContext, this.mRef, this.mHandler);
            }
        }
        return this;
    }

    private void showLoginOption(final FirebaseAuthProvider helper, int id2) {
        this.mView.findViewById(id2).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (helper.getProviderType() == SocialProvider.password) {
                    EditText emailText = (EditText)FirebaseLoginDialog.this.mView.findViewById(R.id.email);
                    EditText passwordText = (EditText)FirebaseLoginDialog.this.mView.findViewById(R.id.password);
                    helper.login(emailText.getText().toString(), passwordText.getText().toString());
                    passwordText.setText((CharSequence)"");
                } else {
                    helper.login();
                }
                FirebaseLoginDialog.this.mActiveProvider = helper.getProviderType();
                FirebaseLoginDialog.this.mView.findViewById(R.id.login_section).setVisibility(8);
                FirebaseLoginDialog.this.mView.findViewById(R.id.loading_section).setVisibility(0);
            }
        });
    }
}

