/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.firebase.client.Firebase;
import com.firebase.client.Query;
import com.firebase.ui.FirebaseArray;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class FirebaseRecyclerViewAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    Class<T> mModelClass;
    protected int mModelLayout;
    Class<VH> mViewHolderClass;
    FirebaseArray mSnapshots;

    public FirebaseRecyclerViewAdapter(Class<T> modelClass, int modelLayout, Class<VH> viewHolderClass, Query ref) {
        this.mModelClass = modelClass;
        this.mModelLayout = modelLayout;
        this.mViewHolderClass = viewHolderClass;
        this.mSnapshots = new FirebaseArray(ref);
        this.mSnapshots.setOnChangedListener(new FirebaseArray.OnChangedListener(){

            @Override
            public void onChanged(FirebaseArray.OnChangedListener.EventType type, int index, int oldIndex) {
                switch (type) {
                    case Added: {
                        FirebaseRecyclerViewAdapter.this.notifyItemInserted(index);
                        break;
                    }
                    case Changed: {
                        FirebaseRecyclerViewAdapter.this.notifyItemChanged(index);
                        break;
                    }
                    case Removed: {
                        FirebaseRecyclerViewAdapter.this.notifyItemRemoved(index);
                        break;
                    }
                    case Moved: {
                        FirebaseRecyclerViewAdapter.this.notifyItemMoved(oldIndex, index);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Incomplete case statement");
                    }
                }
            }
        });
    }

    public FirebaseRecyclerViewAdapter(Class<T> modelClass, int modelLayout, Class<VH> viewHolderClass, Firebase ref) {
        this(modelClass, modelLayout, viewHolderClass, (Query)ref);
    }

    public void cleanup() {
        this.mSnapshots.cleanup();
    }

    public int getItemCount() {
        return this.mSnapshots.getCount();
    }

    public T getItem(int position) {
        return (T)this.mSnapshots.getItem(position).getValue(this.mModelClass);
    }

    public Firebase getRef(int position) {
        return this.mSnapshots.getItem(position).getRef();
    }

    public long getItemId(int position) {
        return this.mSnapshots.getItem(position).getKey().hashCode();
    }

    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewGroup view = (ViewGroup)LayoutInflater.from((Context)parent.getContext()).inflate(this.mModelLayout, parent, false);
        try {
            Constructor<VH> constructor = this.mViewHolderClass.getConstructor(View.class);
            return (VH)((RecyclerView.ViewHolder)constructor.newInstance(view));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void onBindViewHolder(VH viewHolder, int i) {
        T model = this.getItem(i);
        this.populateViewHolder(viewHolder, model);
    }

    public abstract void populateViewHolder(VH var1, T var2);
}

