/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.storage.images;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StreamDownloadTask;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;

public class FirebaseImageLoader
implements ModelLoader<StorageReference, InputStream> {
    private static final String TAG = "FirebaseImageLoader";

    @Nullable
    public ModelLoader.LoadData<InputStream> buildLoadData(StorageReference reference, int height, int width, Options options) {
        return new ModelLoader.LoadData((Key)new FirebaseStorageKey(reference), (DataFetcher)new FirebaseStorageFetcher(reference));
    }

    public boolean handles(StorageReference reference) {
        return true;
    }

    private static class FirebaseStorageFetcher
    implements DataFetcher<InputStream> {
        private StorageReference mRef;
        private StreamDownloadTask mStreamTask;
        private InputStream mInputStream;

        public FirebaseStorageFetcher(StorageReference ref) {
            this.mRef = ref;
        }

        public void loadData(Priority priority, final DataFetcher.DataCallback<? super InputStream> callback) {
            this.mStreamTask = this.mRef.getStream();
            this.mStreamTask.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StreamDownloadTask.TaskSnapshot>(){

                public void onSuccess(StreamDownloadTask.TaskSnapshot snapshot) {
                    FirebaseStorageFetcher.this.mInputStream = snapshot.getStream();
                    callback.onDataReady((Object)FirebaseStorageFetcher.this.mInputStream);
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    callback.onLoadFailed(e);
                }
            });
        }

        public void cleanup() {
            if (this.mInputStream != null) {
                try {
                    this.mInputStream.close();
                    this.mInputStream = null;
                }
                catch (IOException e) {
                    Log.w((String)FirebaseImageLoader.TAG, (String)"Could not close stream", (Throwable)e);
                }
            }
        }

        public void cancel() {
            if (this.mStreamTask != null && this.mStreamTask.isInProgress()) {
                this.mStreamTask.cancel();
            }
        }

        @NonNull
        public Class<InputStream> getDataClass() {
            return InputStream.class;
        }

        @NonNull
        public DataSource getDataSource() {
            return DataSource.REMOTE;
        }
    }

    private static class FirebaseStorageKey
    implements Key {
        private StorageReference mRef;

        public FirebaseStorageKey(StorageReference ref) {
            this.mRef = ref;
        }

        public void updateDiskCacheKey(MessageDigest digest) {
            digest.update(this.mRef.getPath().getBytes(Charset.defaultCharset()));
        }
    }

    public static class Factory
    implements ModelLoaderFactory<StorageReference, InputStream> {
        public ModelLoader<StorageReference, InputStream> build(MultiModelLoaderFactory factory) {
            return new FirebaseImageLoader();
        }

        public void teardown() {
        }
    }
}

