/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.common;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import com.firebase.ui.common.BaseCachingSnapshotParser;
import com.firebase.ui.common.BaseChangeEventListener;
import com.firebase.ui.common.ChangeEventType;
import com.firebase.ui.common.Preconditions;
import java.util.AbstractList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseObservableSnapshotArray<S, E, L extends BaseChangeEventListener<S, E>, T>
extends AbstractList<T> {
    private final List<L> mListeners = new CopyOnWriteArrayList<L>();
    private final BaseCachingSnapshotParser<S, T> mCachingParser;
    private boolean mHasDataChanged = false;

    public BaseObservableSnapshotArray(@NonNull BaseCachingSnapshotParser<S, T> parser) {
        this.mCachingParser = Preconditions.checkNotNull(parser);
    }

    @NonNull
    protected abstract List<S> getSnapshots();

    @Override
    @NonNull
    public T get(int index) {
        return this.mCachingParser.parseSnapshot(this.getSnapshot(index));
    }

    @Override
    public int size() {
        return this.getSnapshots().size();
    }

    @NonNull
    public S getSnapshot(int index) {
        return this.getSnapshots().get(index);
    }

    @CallSuper
    @NonNull
    public L addChangeEventListener(@NonNull L listener) {
        Preconditions.checkNotNull(listener);
        boolean wasListening = this.isListening();
        this.mListeners.add(listener);
        for (int i = 0; i < this.size(); ++i) {
            listener.onChildChanged(ChangeEventType.ADDED, this.getSnapshot(i), i, -1);
        }
        if (this.mHasDataChanged) {
            listener.onDataChanged();
        }
        if (!wasListening) {
            this.onCreate();
        }
        return listener;
    }

    @CallSuper
    public void removeChangeEventListener(@NonNull L listener) {
        Preconditions.checkNotNull(listener);
        boolean wasListening = this.isListening();
        this.mListeners.remove(listener);
        if (!this.isListening() && wasListening) {
            this.onDestroy();
        }
    }

    @CallSuper
    public void removeAllListeners() {
        for (BaseChangeEventListener listener : this.mListeners) {
            this.removeChangeEventListener(listener);
        }
    }

    @CallSuper
    protected void onCreate() {
    }

    @CallSuper
    protected void onDestroy() {
        this.mHasDataChanged = false;
        this.getSnapshots().clear();
        this.mCachingParser.clear();
    }

    public boolean isListening() {
        return !this.mListeners.isEmpty();
    }

    public boolean isListening(@NonNull L listener) {
        return this.mListeners.contains(listener);
    }

    @Override
    public void clear() {
        this.getSnapshots().clear();
        this.notifyOnDataChanged();
    }

    protected final void notifyOnChildChanged(@NonNull ChangeEventType type, @NonNull S snapshot, int newIndex, int oldIndex) {
        if (type == ChangeEventType.CHANGED || type == ChangeEventType.REMOVED) {
            this.mCachingParser.invalidate(snapshot);
        }
        for (BaseChangeEventListener listener : this.mListeners) {
            listener.onChildChanged(type, snapshot, newIndex, oldIndex);
        }
    }

    protected final void notifyOnDataChanged() {
        this.mHasDataChanged = true;
        for (BaseChangeEventListener listener : this.mListeners) {
            listener.onDataChanged();
        }
    }

    protected final void notifyOnError(@NonNull E e) {
        for (BaseChangeEventListener listener : this.mListeners) {
            listener.onError(e);
        }
    }
}

