/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel;

import android.app.Application;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.util.GoogleApiUtils;
import com.firebase.ui.auth.viewmodel.OperableViewModel;
import com.google.android.gms.auth.api.credentials.CredentialsClient;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class AuthViewModelBase<T>
extends OperableViewModel<FlowParameters, Resource<T>> {
    private CredentialsClient mCredentialsClient;
    private FirebaseAuth mAuth;

    protected AuthViewModelBase(Application application) {
        super(application);
    }

    @Override
    protected void onCreate() {
        FirebaseApp app = FirebaseApp.getInstance((String)((FlowParameters)this.getArguments()).appName);
        this.mAuth = FirebaseAuth.getInstance((FirebaseApp)app);
        this.mCredentialsClient = GoogleApiUtils.getCredentialsClient((Context)this.getApplication());
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.mAuth.getCurrentUser();
    }

    protected FirebaseAuth getAuth() {
        return this.mAuth;
    }

    protected CredentialsClient getCredentialsClient() {
        return this.mCredentialsClient;
    }

    @VisibleForTesting
    public void initializeForTesting(FlowParameters parameters, FirebaseAuth auth, CredentialsClient client) {
        this.setArguments(parameters);
        this.mAuth = auth;
        this.mCredentialsClient = client;
    }
}

