/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.ui.fieldvalidators;

import android.util.Patterns;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.util.ui.fieldvalidators.BaseValidator;
import com.google.android.material.textfield.TextInputLayout;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailFieldValidator
extends BaseValidator {
    public EmailFieldValidator(TextInputLayout errorContainer) {
        super(errorContainer);
        this.mErrorMessage = this.mErrorContainer.getResources().getString(R.string.fui_invalid_email_address);
        this.mEmptyMessage = this.mErrorContainer.getResources().getString(R.string.fui_missing_email_address);
    }

    @Override
    protected boolean isValid(CharSequence charSequence) {
        return Patterns.EMAIL_ADDRESS.matcher(charSequence).matches();
    }
}

